package zio.aws.pi.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.pi.model.primitives.{
  ISOTimestamp,
  IdentifierString,
  AnalysisReportId
}
import scala.jdk.CollectionConverters._
final case class AnalysisReport(
    analysisReportId: AnalysisReportId,
    identifier: Optional[IdentifierString] = Optional.Absent,
    serviceType: Optional[zio.aws.pi.model.ServiceType] = Optional.Absent,
    createTime: Optional[ISOTimestamp] = Optional.Absent,
    startTime: Optional[ISOTimestamp] = Optional.Absent,
    endTime: Optional[ISOTimestamp] = Optional.Absent,
    status: Optional[zio.aws.pi.model.AnalysisStatus] = Optional.Absent,
    insights: Optional[Iterable[zio.aws.pi.model.Insight]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.AnalysisReport = {
    import AnalysisReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.AnalysisReport
      .builder()
      .analysisReportId(
        AnalysisReportId.unwrap(analysisReportId): java.lang.String
      )
      .optionallyWith(
        identifier.map(value =>
          IdentifierString.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(
        createTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        startTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        insights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insights)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.AnalysisReport.ReadOnly =
    zio.aws.pi.model.AnalysisReport.wrap(buildAwsValue())
}
object AnalysisReport {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pi.model.AnalysisReport] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.AnalysisReport =
      zio.aws.pi.model.AnalysisReport(
        analysisReportId,
        identifier.map(value => value),
        serviceType.map(value => value),
        createTime.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        insights.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def analysisReportId: AnalysisReportId
    def identifier: Optional[IdentifierString]
    def serviceType: Optional[zio.aws.pi.model.ServiceType]
    def createTime: Optional[ISOTimestamp]
    def startTime: Optional[ISOTimestamp]
    def endTime: Optional[ISOTimestamp]
    def status: Optional[zio.aws.pi.model.AnalysisStatus]
    def insights: Optional[List[zio.aws.pi.model.Insight.ReadOnly]]
    def getAnalysisReportId: ZIO[Any, Nothing, AnalysisReportId] =
      ZIO.succeed(analysisReportId)
    def getIdentifier: ZIO[Any, AwsError, IdentifierString] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getServiceType: ZIO[Any, AwsError, zio.aws.pi.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getCreateTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.pi.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsights
        : ZIO[Any, AwsError, List[zio.aws.pi.model.Insight.ReadOnly]] =
      AwsError.unwrapOptionField("insights", insights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.AnalysisReport
  ) extends zio.aws.pi.model.AnalysisReport.ReadOnly {
    override val analysisReportId: AnalysisReportId =
      zio.aws.pi.model.primitives.AnalysisReportId(impl.analysisReportId())
    override val identifier: Optional[IdentifierString] = zio.aws.core.internal
      .optionalFromNullable(impl.identifier())
      .map(value => zio.aws.pi.model.primitives.IdentifierString(value))
    override val serviceType: Optional[zio.aws.pi.model.ServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value => zio.aws.pi.model.ServiceType.wrap(value))
    override val createTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val startTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val endTime: Optional[ISOTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val status: Optional[zio.aws.pi.model.AnalysisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.pi.model.AnalysisStatus.wrap(value))
    override val insights: Optional[List[zio.aws.pi.model.Insight.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insights())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.Insight.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.AnalysisReport
  ): zio.aws.pi.model.AnalysisReport.ReadOnly = new Wrapper(impl)
}
