package zio.aws.pi
import zio.aws.pi.model.ListAvailableResourceMetricsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.pi.PiAsyncClient
import zio.aws.pi.model.{
  GetResourceMetricsRequest,
  ListAvailableResourceMetricsRequest,
  ListPerformanceAnalysisReportsRequest,
  ListAvailableResourceDimensionsRequest,
  GetPerformanceAnalysisReportRequest,
  GetResourceMetadataRequest,
  ListTagsForResourceRequest,
  DeletePerformanceAnalysisReportRequest,
  DescribeDimensionKeysRequest,
  GetDimensionKeyDetailsRequest,
  UntagResourceRequest,
  CreatePerformanceAnalysisReportRequest,
  TagResourceRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZIO, ZEnvironment, URLayer}
import zio.stream.ZStream
object PiMock extends Mock[Pi] {
  object GetResourceMetrics
      extends Effect[GetResourceMetricsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
        zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
      ]]
  object GetResourceMetricsPaginated
      extends Effect[
        GetResourceMetricsRequest,
        AwsError,
        zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
      ]
  object ListAvailableResourceMetrics
      extends Stream[
        ListAvailableResourceMetricsRequest,
        AwsError,
        zio.aws.pi.model.ResponseResourceMetric.ReadOnly
      ]
  object ListAvailableResourceMetricsPaginated
      extends Effect[ListAvailableResourceMetricsRequest, AwsError, ReadOnly]
  object DeletePerformanceAnalysisReport
      extends Effect[
        DeletePerformanceAnalysisReportRequest,
        AwsError,
        zio.aws.pi.model.DeletePerformanceAnalysisReportResponse.ReadOnly
      ]
  object ListPerformanceAnalysisReports
      extends Stream[
        ListPerformanceAnalysisReportsRequest,
        AwsError,
        zio.aws.pi.model.AnalysisReportSummary.ReadOnly
      ]
  object ListPerformanceAnalysisReportsPaginated
      extends Effect[
        ListPerformanceAnalysisReportsRequest,
        AwsError,
        zio.aws.pi.model.ListPerformanceAnalysisReportsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.pi.model.UntagResourceResponse.ReadOnly
      ]
  object GetResourceMetadata
      extends Effect[
        GetResourceMetadataRequest,
        AwsError,
        zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly
      ]
  object CreatePerformanceAnalysisReport
      extends Effect[
        CreatePerformanceAnalysisReportRequest,
        AwsError,
        zio.aws.pi.model.CreatePerformanceAnalysisReportResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.pi.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListAvailableResourceDimensions
      extends Stream[
        ListAvailableResourceDimensionsRequest,
        AwsError,
        zio.aws.pi.model.MetricDimensionGroups.ReadOnly
      ]
  object ListAvailableResourceDimensionsPaginated
      extends Effect[
        ListAvailableResourceDimensionsRequest,
        AwsError,
        zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.pi.model.TagResourceResponse.ReadOnly
      ]
  object DescribeDimensionKeys
      extends Effect[
        DescribeDimensionKeysRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
          zio.aws.pi.model.DimensionKeyDescription.ReadOnly
        ]
      ]
  object DescribeDimensionKeysPaginated
      extends Effect[
        DescribeDimensionKeysRequest,
        AwsError,
        zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
      ]
  object GetPerformanceAnalysisReport
      extends Effect[
        GetPerformanceAnalysisReportRequest,
        AwsError,
        zio.aws.pi.model.GetPerformanceAnalysisReportResponse.ReadOnly
      ]
  object GetDimensionKeyDetails
      extends Effect[
        GetDimensionKeyDetailsRequest,
        AwsError,
        zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Pi] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Pi] { rts =>
        ZIO.succeed {
          new Pi {
            val api: PiAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Pi = this
            def getResourceMetrics(
                request: GetResourceMetricsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly,
              zio.aws.pi.model.MetricKeyDataPoints.ReadOnly
            ]] = proxy(GetResourceMetrics, request)
            def getResourceMetricsPaginated(
                request: GetResourceMetricsRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.GetResourceMetricsResponse.ReadOnly
            ] = proxy(GetResourceMetricsPaginated, request)
            def listAvailableResourceMetrics(
                request: ListAvailableResourceMetricsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pi.model.ResponseResourceMetric.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAvailableResourceMetrics, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAvailableResourceMetricsPaginated(
                request: ListAvailableResourceMetricsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListAvailableResourceMetricsPaginated, request)
            def deletePerformanceAnalysisReport(
                request: DeletePerformanceAnalysisReportRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.DeletePerformanceAnalysisReportResponse.ReadOnly
            ] = proxy(DeletePerformanceAnalysisReport, request)
            def listPerformanceAnalysisReports(
                request: ListPerformanceAnalysisReportsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pi.model.AnalysisReportSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPerformanceAnalysisReports, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPerformanceAnalysisReportsPaginated(
                request: ListPerformanceAnalysisReportsRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.ListPerformanceAnalysisReportsResponse.ReadOnly
            ] = proxy(ListPerformanceAnalysisReportsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.pi.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def getResourceMetadata(request: GetResourceMetadataRequest): IO[
              AwsError,
              zio.aws.pi.model.GetResourceMetadataResponse.ReadOnly
            ] = proxy(GetResourceMetadata, request)
            def createPerformanceAnalysisReport(
                request: CreatePerformanceAnalysisReportRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.CreatePerformanceAnalysisReportResponse.ReadOnly
            ] = proxy(CreatePerformanceAnalysisReport, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.pi.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listAvailableResourceDimensions(
                request: ListAvailableResourceDimensionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pi.model.MetricDimensionGroups.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAvailableResourceDimensions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAvailableResourceDimensionsPaginated(
                request: ListAvailableResourceDimensionsRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly
            ] = proxy(ListAvailableResourceDimensionsPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.pi.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def describeDimensionKeys(
                request: DescribeDimensionKeysRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly,
              zio.aws.pi.model.DimensionKeyDescription.ReadOnly
            ]] = proxy(DescribeDimensionKeys, request)
            def describeDimensionKeysPaginated(
                request: DescribeDimensionKeysRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly
            ] = proxy(DescribeDimensionKeysPaginated, request)
            def getPerformanceAnalysisReport(
                request: GetPerformanceAnalysisReportRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.GetPerformanceAnalysisReportResponse.ReadOnly
            ] = proxy(GetPerformanceAnalysisReport, request)
            def getDimensionKeyDetails(
                request: GetDimensionKeyDetailsRequest
            ): IO[
              AwsError,
              zio.aws.pi.model.GetDimensionKeyDetailsResponse.ReadOnly
            ] = proxy(GetDimensionKeyDetails, request)
          }
        }
      }
    }
  }
}
