package zio.aws.pi.model
import zio.aws.pi.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseResourceMetric(
    metric: Optional[String] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    unit: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ResponseResourceMetric = {
    import ResponseResourceMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ResponseResourceMetric
      .builder()
      .optionallyWith(metric.map(value => value: java.lang.String))(_.metric)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.ResponseResourceMetric.ReadOnly =
    zio.aws.pi.model.ResponseResourceMetric.wrap(buildAwsValue())
}
object ResponseResourceMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ResponseResourceMetric =
      zio.aws.pi.model.ResponseResourceMetric(
        metric.map(value => value),
        description.map(value => value),
        unit.map(value => value)
      )
    def metric: Optional[String]
    def description: Optional[Description]
    def unit: Optional[String]
    def getMetric: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("metric", metric)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ) extends zio.aws.pi.model.ResponseResourceMetric.ReadOnly {
    override val metric: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.metric())
      .map(value => value: String)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.pi.model.primitives.Description(value))
    override val unit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetric
  ): zio.aws.pi.model.ResponseResourceMetric.ReadOnly = new Wrapper(impl)
}
