package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseResourceMetricKey(
    metric: String,
    dimensions: Optional[Map[RequestString, RequestString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey = {
    import ResponseResourceMetricKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey
      .builder()
      .metric(metric: java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly =
    zio.aws.pi.model.ResponseResourceMetricKey.wrap(buildAwsValue())
}
object ResponseResourceMetricKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ResponseResourceMetricKey =
      zio.aws.pi.model
        .ResponseResourceMetricKey(metric, dimensions.map(value => value))
    def metric: String
    def dimensions: Optional[Map[RequestString, RequestString]]
    def getMetric: ZIO[Any, Nothing, String] = ZIO.succeed(metric)
    def getDimensions: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey
  ) extends zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly {
    override val metric: String = impl.metric(): String
    override val dimensions: Optional[Map[RequestString, RequestString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pi.model.primitives.RequestString(
                key
              ) -> zio.aws.pi.model.primitives.RequestString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ResponseResourceMetricKey
  ): zio.aws.pi.model.ResponseResourceMetricKey.ReadOnly = new Wrapper(impl)
}
