package zio.aws.pi.model
import zio.aws.pi.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAvailableResourceDimensionsResponse(
    metricDimensions: Optional[
      Iterable[zio.aws.pi.model.MetricDimensionGroups]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse = {
    import ListAvailableResourceDimensionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse
      .builder()
      .optionallyWith(
        metricDimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDimensions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly =
    zio.aws.pi.model.ListAvailableResourceDimensionsResponse
      .wrap(buildAwsValue())
}
object ListAvailableResourceDimensionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.ListAvailableResourceDimensionsResponse =
      zio.aws.pi.model.ListAvailableResourceDimensionsResponse(
        metricDimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metricDimensions
        : Optional[List[zio.aws.pi.model.MetricDimensionGroups.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMetricDimensions: ZIO[Any, AwsError, List[
      zio.aws.pi.model.MetricDimensionGroups.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDimensions", metricDimensions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse
  ) extends zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly {
    override val metricDimensions
        : Optional[List[zio.aws.pi.model.MetricDimensionGroups.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.MetricDimensionGroups.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse
  ): zio.aws.pi.model.ListAvailableResourceDimensionsResponse.ReadOnly =
    new Wrapper(impl)
}
