package zio.aws.pi.model
import zio.aws.pi.model.primitives.RequestString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetResourceMetadataRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: RequestString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest = {
    import GetResourceMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(RequestString.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetResourceMetadataRequest.ReadOnly =
    zio.aws.pi.model.GetResourceMetadataRequest.wrap(buildAwsValue())
}
object GetResourceMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetResourceMetadataRequest =
      zio.aws.pi.model.GetResourceMetadataRequest(serviceType, identifier)
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: RequestString
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest
  ) extends zio.aws.pi.model.GetResourceMetadataRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest
  ): zio.aws.pi.model.GetResourceMetadataRequest.ReadOnly = new Wrapper(impl)
}
