package zio.aws.pi.model
import zio.aws.pi.model.primitives.{
  NextToken,
  RequestString,
  ISOTimestamp,
  Integer,
  MaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeDimensionKeysRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: RequestString,
    startTime: ISOTimestamp,
    endTime: ISOTimestamp,
    metric: RequestString,
    periodInSeconds: Option[Integer] = None,
    groupBy: zio.aws.pi.model.DimensionGroup,
    additionalMetrics: Option[Iterable[RequestString]] = None,
    partitionBy: Option[zio.aws.pi.model.DimensionGroup] = None,
    filter: Option[Map[RequestString, RequestString]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest = {
    import DescribeDimensionKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(RequestString.unwrap(identifier): java.lang.String)
      .startTime(ISOTimestamp.unwrap(startTime): Instant)
      .endTime(ISOTimestamp.unwrap(endTime): Instant)
      .metric(RequestString.unwrap(metric): java.lang.String)
      .optionallyWith(periodInSeconds.map(value => value: java.lang.Integer))(
        _.periodInSeconds
      )
      .groupBy(groupBy.buildAwsValue())
      .optionallyWith(
        additionalMetrics.map(value =>
          value.map { item =>
            RequestString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMetrics)
      .optionallyWith(partitionBy.map(value => value.buildAwsValue()))(
        _.partitionBy
      )
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (RequestString.unwrap(key): java.lang.String) -> (RequestString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly =
    zio.aws.pi.model.DescribeDimensionKeysRequest.wrap(buildAwsValue())
}
object DescribeDimensionKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DescribeDimensionKeysRequest =
      zio.aws.pi.model.DescribeDimensionKeysRequest(
        serviceType,
        identifier,
        startTime,
        endTime,
        metric,
        periodInSeconds.map(value => value),
        groupBy.asEditable,
        additionalMetrics.map(value => value),
        partitionBy.map(value => value.asEditable),
        filter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: RequestString
    def startTime: ISOTimestamp
    def endTime: ISOTimestamp
    def metric: RequestString
    def periodInSeconds: Option[Integer]
    def groupBy: zio.aws.pi.model.DimensionGroup.ReadOnly
    def additionalMetrics: Option[List[RequestString]]
    def partitionBy: Option[zio.aws.pi.model.DimensionGroup.ReadOnly]
    def filter: Option[Map[RequestString, RequestString]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(identifier)
    def getStartTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(endTime)
    def getMetric: ZIO[Any, Nothing, RequestString] = ZIO.succeed(metric)
    def getPeriodInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("periodInSeconds", periodInSeconds)
    def getGroupBy
        : ZIO[Any, Nothing, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      ZIO.succeed(groupBy)
    def getAdditionalMetrics: ZIO[Any, AwsError, List[RequestString]] =
      AwsError.unwrapOptionField("additionalMetrics", additionalMetrics)
    def getPartitionBy
        : ZIO[Any, AwsError, zio.aws.pi.model.DimensionGroup.ReadOnly] =
      AwsError.unwrapOptionField("partitionBy", partitionBy)
    def getFilter: ZIO[Any, AwsError, Map[RequestString, RequestString]] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ) extends zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.identifier())
    override val startTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.startTime())
    override val endTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.endTime())
    override val metric: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.metric())
    override val periodInSeconds: Option[Integer] =
      scala.Option(impl.periodInSeconds()).map(value => value: Integer)
    override val groupBy: zio.aws.pi.model.DimensionGroup.ReadOnly =
      zio.aws.pi.model.DimensionGroup.wrap(impl.groupBy())
    override val additionalMetrics: Option[List[RequestString]] = scala
      .Option(impl.additionalMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.primitives.RequestString(item)
        }.toList
      )
    override val partitionBy: Option[zio.aws.pi.model.DimensionGroup.ReadOnly] =
      scala
        .Option(impl.partitionBy())
        .map(value => zio.aws.pi.model.DimensionGroup.wrap(value))
    override val filter: Option[Map[RequestString, RequestString]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pi.model.primitives.RequestString(
              key
            ) -> zio.aws.pi.model.primitives.RequestString(value)
          })
          .toMap
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest
  ): zio.aws.pi.model.DescribeDimensionKeysRequest.ReadOnly = new Wrapper(impl)
}
