package zio.aws.pi.model
import zio.aws.pi.model.primitives.{
  NextToken,
  RequestString,
  ISOTimestamp,
  Integer,
  MaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetResourceMetricsRequest(
    serviceType: zio.aws.pi.model.ServiceType,
    identifier: RequestString,
    metricQueries: Iterable[zio.aws.pi.model.MetricQuery],
    startTime: ISOTimestamp,
    endTime: ISOTimestamp,
    periodInSeconds: Option[Integer] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest = {
    import GetResourceMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest
      .builder()
      .serviceType(serviceType.unwrap)
      .identifier(RequestString.unwrap(identifier): java.lang.String)
      .metricQueries(metricQueries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .startTime(ISOTimestamp.unwrap(startTime): Instant)
      .endTime(ISOTimestamp.unwrap(endTime): Instant)
      .optionallyWith(
        periodInSeconds.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.periodInSeconds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.GetResourceMetricsRequest.ReadOnly =
    zio.aws.pi.model.GetResourceMetricsRequest.wrap(buildAwsValue())
}
object GetResourceMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.GetResourceMetricsRequest =
      zio.aws.pi.model.GetResourceMetricsRequest(
        serviceType,
        identifier,
        metricQueries.map { item =>
          item.asEditable
        },
        startTime,
        endTime,
        periodInSeconds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceType: zio.aws.pi.model.ServiceType
    def identifier: RequestString
    def metricQueries: List[zio.aws.pi.model.MetricQuery.ReadOnly]
    def startTime: ISOTimestamp
    def endTime: ISOTimestamp
    def periodInSeconds: Option[Integer]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getServiceType: ZIO[Any, Nothing, zio.aws.pi.model.ServiceType] =
      ZIO.succeed(serviceType)
    def getIdentifier: ZIO[Any, Nothing, RequestString] =
      ZIO.succeed(identifier)
    def getMetricQueries
        : ZIO[Any, Nothing, List[zio.aws.pi.model.MetricQuery.ReadOnly]] =
      ZIO.succeed(metricQueries)
    def getStartTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, ISOTimestamp] = ZIO.succeed(endTime)
    def getPeriodInSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("periodInSeconds", periodInSeconds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest
  ) extends zio.aws.pi.model.GetResourceMetricsRequest.ReadOnly {
    override val serviceType: zio.aws.pi.model.ServiceType =
      zio.aws.pi.model.ServiceType.wrap(impl.serviceType())
    override val identifier: RequestString =
      zio.aws.pi.model.primitives.RequestString(impl.identifier())
    override val metricQueries: List[zio.aws.pi.model.MetricQuery.ReadOnly] =
      impl
        .metricQueries()
        .asScala
        .map { item =>
          zio.aws.pi.model.MetricQuery.wrap(item)
        }
        .toList
    override val startTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.startTime())
    override val endTime: ISOTimestamp =
      zio.aws.pi.model.primitives.ISOTimestamp(impl.endTime())
    override val periodInSeconds: Option[Integer] = scala
      .Option(impl.periodInSeconds())
      .map(value => zio.aws.pi.model.primitives.Integer(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.pi.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest
  ): zio.aws.pi.model.GetResourceMetricsRequest.ReadOnly = new Wrapper(impl)
}
