package zio.aws.pi.model
import zio.aws.pi.model.primitives.{NextToken, ISOTimestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeDimensionKeysResponse(
    alignedStartTime: Option[ISOTimestamp] = None,
    alignedEndTime: Option[ISOTimestamp] = None,
    partitionKeys: Option[Iterable[zio.aws.pi.model.ResponsePartitionKey]] =
      None,
    keys: Option[Iterable[zio.aws.pi.model.DimensionKeyDescription]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse = {
    import DescribeDimensionKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
      .builder()
      .optionallyWith(
        alignedStartTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedStartTime)
      .optionallyWith(
        alignedEndTime.map(value => ISOTimestamp.unwrap(value): Instant)
      )(_.alignedEndTime)
      .optionallyWith(
        partitionKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partitionKeys)
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly =
    zio.aws.pi.model.DescribeDimensionKeysResponse.wrap(buildAwsValue())
}
object DescribeDimensionKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pi.model.DescribeDimensionKeysResponse =
      zio.aws.pi.model.DescribeDimensionKeysResponse(
        alignedStartTime.map(value => value),
        alignedEndTime.map(value => value),
        partitionKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def alignedStartTime: Option[ISOTimestamp]
    def alignedEndTime: Option[ISOTimestamp]
    def partitionKeys
        : Option[List[zio.aws.pi.model.ResponsePartitionKey.ReadOnly]]
    def keys: Option[List[zio.aws.pi.model.DimensionKeyDescription.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAlignedStartTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedStartTime", alignedStartTime)
    def getAlignedEndTime: ZIO[Any, AwsError, ISOTimestamp] =
      AwsError.unwrapOptionField("alignedEndTime", alignedEndTime)
    def getPartitionKeys: ZIO[Any, AwsError, List[
      zio.aws.pi.model.ResponsePartitionKey.ReadOnly
    ]] = AwsError.unwrapOptionField("partitionKeys", partitionKeys)
    def getKeys: ZIO[Any, AwsError, List[
      zio.aws.pi.model.DimensionKeyDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("keys", keys)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ) extends zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly {
    override val alignedStartTime: Option[ISOTimestamp] = scala
      .Option(impl.alignedStartTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val alignedEndTime: Option[ISOTimestamp] = scala
      .Option(impl.alignedEndTime())
      .map(value => zio.aws.pi.model.primitives.ISOTimestamp(value))
    override val partitionKeys
        : Option[List[zio.aws.pi.model.ResponsePartitionKey.ReadOnly]] = scala
      .Option(impl.partitionKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pi.model.ResponsePartitionKey.wrap(item)
        }.toList
      )
    override val keys
        : Option[List[zio.aws.pi.model.DimensionKeyDescription.ReadOnly]] =
      scala
        .Option(impl.keys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pi.model.DimensionKeyDescription.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pi.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse
  ): zio.aws.pi.model.DescribeDimensionKeysResponse.ReadOnly = new Wrapper(impl)
}
