package zio.aws.personalizeruntime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.personalizeruntime.model.primitives.{
  FilterAttributeName,
  FilterAttributeValue,
  PercentPromotedItems,
  Arn,
  Name
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Promotion(
    name: Optional[Name] = Optional.Absent,
    percentPromotedItems: Optional[PercentPromotedItems] = Optional.Absent,
    filterArn: Optional[Arn] = Optional.Absent,
    filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.Promotion = {
    import Promotion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.Promotion
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        percentPromotedItems.map(value =>
          PercentPromotedItems.unwrap(value): Integer
        )
      )(_.percentPromotedItems)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        filterValues.map(value =>
          value
            .map({ case (key, value) =>
              (FilterAttributeName
                .unwrap(key): java.lang.String) -> (FilterAttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filterValues)
      .build()
  }
  def asReadOnly: zio.aws.personalizeruntime.model.Promotion.ReadOnly =
    zio.aws.personalizeruntime.model.Promotion.wrap(buildAwsValue())
}
object Promotion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.Promotion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeruntime.model.Promotion =
      zio.aws.personalizeruntime.model.Promotion(
        name.map(value => value),
        percentPromotedItems.map(value => value),
        filterArn.map(value => value),
        filterValues.map(value => value)
      )
    def name: Optional[Name]
    def percentPromotedItems: Optional[PercentPromotedItems]
    def filterArn: Optional[Arn]
    def filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPercentPromotedItems: ZIO[Any, AwsError, PercentPromotedItems] =
      AwsError.unwrapOptionField("percentPromotedItems", percentPromotedItems)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFilterValues
        : ZIO[Any, AwsError, Map[FilterAttributeName, FilterAttributeValue]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.Promotion
  ) extends zio.aws.personalizeruntime.model.Promotion.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.personalizeruntime.model.primitives.Name(value))
    override val percentPromotedItems: Optional[PercentPromotedItems] =
      zio.aws.core.internal
        .optionalFromNullable(impl.percentPromotedItems())
        .map(value =>
          zio.aws.personalizeruntime.model.primitives
            .PercentPromotedItems(value)
        )
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val filterValues
        : Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterValues())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalizeruntime.model.primitives.FilterAttributeName(
                key
              ) -> zio.aws.personalizeruntime.model.primitives
                .FilterAttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.Promotion
  ): zio.aws.personalizeruntime.model.Promotion.ReadOnly = new Wrapper(impl)
}
