package zio.aws.personalizeruntime.model
import zio.aws.personalizeruntime.model.primitives.{
  FilterAttributeName,
  AttributeName,
  UserID,
  ItemID,
  FilterAttributeValue,
  Arn,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPersonalizedRankingRequest(
    campaignArn: Arn,
    inputList: Iterable[ItemID],
    userId: UserID,
    context: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    filterArn: Optional[Arn] = Optional.Absent,
    filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest = {
    import GetPersonalizedRankingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest
      .builder()
      .campaignArn(Arn.unwrap(campaignArn): java.lang.String)
      .inputList(inputList.map { item =>
        ItemID.unwrap(item): java.lang.String
      }.asJavaCollection)
      .userId(UserID.unwrap(userId): java.lang.String)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        filterValues.map(value =>
          value
            .map({ case (key, value) =>
              (FilterAttributeName
                .unwrap(key): java.lang.String) -> (FilterAttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filterValues)
      .build()
  }
  def asReadOnly
      : zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest.ReadOnly =
    zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest
      .wrap(buildAwsValue())
}
object GetPersonalizedRankingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest =
      zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest(
        campaignArn,
        inputList,
        userId,
        context.map(value => value),
        filterArn.map(value => value),
        filterValues.map(value => value)
      )
    def campaignArn: Arn
    def inputList: List[ItemID]
    def userId: UserID
    def context: Optional[Map[AttributeName, AttributeValue]]
    def filterArn: Optional[Arn]
    def filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]]
    def getCampaignArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(campaignArn)
    def getInputList: ZIO[Any, Nothing, List[ItemID]] = ZIO.succeed(inputList)
    def getUserId: ZIO[Any, Nothing, UserID] = ZIO.succeed(userId)
    def getContext: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("context", context)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFilterValues
        : ZIO[Any, AwsError, Map[FilterAttributeName, FilterAttributeValue]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest
  ) extends zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest.ReadOnly {
    override val campaignArn: Arn =
      zio.aws.personalizeruntime.model.primitives.Arn(impl.campaignArn())
    override val inputList: List[ItemID] = impl
      .inputList()
      .asScala
      .map { item =>
        zio.aws.personalizeruntime.model.primitives.ItemID(item)
      }
      .toList
    override val userId: UserID =
      zio.aws.personalizeruntime.model.primitives.UserID(impl.userId())
    override val context: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalizeruntime.model.primitives.AttributeName(
                key
              ) -> zio.aws.personalizeruntime.model.primitives
                .AttributeValue(value)
            })
            .toMap
        )
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val filterValues
        : Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterValues())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalizeruntime.model.primitives.FilterAttributeName(
                key
              ) -> zio.aws.personalizeruntime.model.primitives
                .FilterAttributeValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest
  ): zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest.ReadOnly =
    new Wrapper(impl)
}
