package zio.aws.personalizeruntime.model
import zio.aws.personalizeruntime.model.primitives.{Name, Score, ItemID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PredictedItem(
    itemId: Optional[ItemID] = Optional.Absent,
    score: Optional[Score] = Optional.Absent,
    promotionName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.PredictedItem = {
    import PredictedItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
      .builder()
      .optionallyWith(
        itemId.map(value => ItemID.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        score.map(value => Score.unwrap(value): java.lang.Double)
      )(_.score)
      .optionallyWith(
        promotionName.map(value => Name.unwrap(value): java.lang.String)
      )(_.promotionName)
      .build()
  }
  def asReadOnly: zio.aws.personalizeruntime.model.PredictedItem.ReadOnly =
    zio.aws.personalizeruntime.model.PredictedItem.wrap(buildAwsValue())
}
object PredictedItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeruntime.model.PredictedItem =
      zio.aws.personalizeruntime.model.PredictedItem(
        itemId.map(value => value),
        score.map(value => value),
        promotionName.map(value => value)
      )
    def itemId: Optional[ItemID]
    def score: Optional[Score]
    def promotionName: Optional[Name]
    def getItemId: ZIO[Any, AwsError, ItemID] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getScore: ZIO[Any, AwsError, Score] =
      AwsError.unwrapOptionField("score", score)
    def getPromotionName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("promotionName", promotionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ) extends zio.aws.personalizeruntime.model.PredictedItem.ReadOnly {
    override val itemId: Optional[ItemID] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.personalizeruntime.model.primitives.ItemID(value))
    override val score: Optional[Score] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => zio.aws.personalizeruntime.model.primitives.Score(value))
    override val promotionName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.promotionName())
      .map(value => zio.aws.personalizeruntime.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ): zio.aws.personalizeruntime.model.PredictedItem.ReadOnly = new Wrapper(impl)
}
