package zio.aws.personalizeruntime
import zio.mock.{Proxy, Mock}
import zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.ReadOnly
import software.amazon.awssdk.services.personalizeruntime.PersonalizeRuntimeAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.personalizeruntime.model.{
  GetRecommendationsRequest,
  GetPersonalizedRankingRequest
}
object PersonalizeRuntimeMock extends Mock[PersonalizeRuntime] {
  object GetPersonalizedRanking
      extends Effect[GetPersonalizedRankingRequest, AwsError, ReadOnly]
  object GetRecommendations
      extends Effect[
        GetRecommendationsRequest,
        AwsError,
        zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, PersonalizeRuntime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, PersonalizeRuntime] { rts =>
        zio.ZIO.succeed {
          new PersonalizeRuntime {
            val api: PersonalizeRuntimeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): PersonalizeRuntime = this
            def getPersonalizedRanking(
                request: GetPersonalizedRankingRequest
            ): IO[AwsError, ReadOnly] = proxy(GetPersonalizedRanking, request)
            def getRecommendations(request: GetRecommendationsRequest): IO[
              AwsError,
              zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly
            ] = proxy(GetRecommendations, request)
          }
        }
      }
    }
  }
}
