package zio.aws.personalizeruntime.model
import zio.aws.personalizeruntime.model.primitives.{Score, ItemID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PredictedItem(
    itemId: Optional[ItemID] = Optional.Absent,
    score: Optional[Score] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.PredictedItem = {
    import PredictedItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
      .builder()
      .optionallyWith(
        itemId.map(value => ItemID.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        score.map(value => Score.unwrap(value): java.lang.Double)
      )(_.score)
      .build()
  }
  def asReadOnly: zio.aws.personalizeruntime.model.PredictedItem.ReadOnly =
    zio.aws.personalizeruntime.model.PredictedItem.wrap(buildAwsValue())
}
object PredictedItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeruntime.model.PredictedItem =
      zio.aws.personalizeruntime.model
        .PredictedItem(itemId.map(value => value), score.map(value => value))
    def itemId: Optional[ItemID]
    def score: Optional[Score]
    def getItemId: ZIO[Any, AwsError, ItemID] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getScore: ZIO[Any, AwsError, Score] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ) extends zio.aws.personalizeruntime.model.PredictedItem.ReadOnly {
    override val itemId: Optional[ItemID] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.personalizeruntime.model.primitives.ItemID(value))
    override val score: Optional[Score] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => zio.aws.personalizeruntime.model.primitives.Score(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.PredictedItem
  ): zio.aws.personalizeruntime.model.PredictedItem.ReadOnly = new Wrapper(impl)
}
