package zio.aws.personalizeruntime
import zio.prelude.Subtype
import zio.aws.personalizeruntime.model.primitives.{
  FilterAttributeName,
  AttributeName,
  ItemID,
  FilterAttributeValue,
  AttributeValue
}
import zio.aws.personalizeruntime.model.primitives.ItemID.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.personalizeruntime.model.primitives.Arn.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.personalizeruntime.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue =
      zio.aws.personalizeruntime.model.primitives.AttributeValue.Type
    object FilterAttributeName extends Subtype[String]
    type FilterAttributeName =
      zio.aws.personalizeruntime.model.primitives.FilterAttributeName.Type
    object FilterAttributeValue extends Subtype[String]
    type FilterAttributeValue =
      zio.aws.personalizeruntime.model.primitives.FilterAttributeValue.Type
    object ItemID extends Subtype[String]
    type ItemID = zio.aws.personalizeruntime.model.primitives.ItemID.Type
    object NumResults extends Subtype[Int]
    type NumResults =
      zio.aws.personalizeruntime.model.primitives.NumResults.Type
    object RecommendationID extends Subtype[String]
    type RecommendationID =
      zio.aws.personalizeruntime.model.primitives.RecommendationID.Type
    object Score extends Subtype[Double]
    type Score = zio.aws.personalizeruntime.model.primitives.Score.Type
    object UserID extends Subtype[String]
    type UserID = zio.aws.personalizeruntime.model.primitives.UserID.Type
  }
  type Context = Map[AttributeName, AttributeValue]
  type FilterValues = Map[FilterAttributeName, FilterAttributeValue]
  type InputList = List[ItemID]
  type ItemList = List[zio.aws.personalizeruntime.model.PredictedItem]
}
