package zio.aws.personalizeruntime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.personalizeruntime.model.primitives.{
  FilterAttributeName,
  AttributeName,
  UserID,
  ItemID,
  FilterAttributeValue,
  Arn,
  NumResults,
  AttributeValue
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetRecommendationsRequest(
    campaignArn: Optional[Arn] = Optional.Absent,
    itemId: Optional[ItemID] = Optional.Absent,
    userId: Optional[UserID] = Optional.Absent,
    numResults: Optional[NumResults] = Optional.Absent,
    context: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    filterArn: Optional[Arn] = Optional.Absent,
    filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      Optional.Absent,
    recommenderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest = {
    import GetRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
      .builder()
      .optionallyWith(
        campaignArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.campaignArn)
      .optionallyWith(
        itemId.map(value => ItemID.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        userId.map(value => UserID.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        numResults.map(value => NumResults.unwrap(value): Integer)
      )(_.numResults)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        filterValues.map(value =>
          value
            .map({ case (key, value) =>
              (FilterAttributeName
                .unwrap(key): java.lang.String) -> (FilterAttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filterValues)
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly =
    zio.aws.personalizeruntime.model.GetRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeruntime.model.GetRecommendationsRequest =
      zio.aws.personalizeruntime.model.GetRecommendationsRequest(
        campaignArn.map(value => value),
        itemId.map(value => value),
        userId.map(value => value),
        numResults.map(value => value),
        context.map(value => value),
        filterArn.map(value => value),
        filterValues.map(value => value),
        recommenderArn.map(value => value)
      )
    def campaignArn: Optional[Arn]
    def itemId: Optional[ItemID]
    def userId: Optional[UserID]
    def numResults: Optional[NumResults]
    def context: Optional[Map[AttributeName, AttributeValue]]
    def filterArn: Optional[Arn]
    def filterValues: Optional[Map[FilterAttributeName, FilterAttributeValue]]
    def recommenderArn: Optional[Arn]
    def getCampaignArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("campaignArn", campaignArn)
    def getItemId: ZIO[Any, AwsError, ItemID] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getUserId: ZIO[Any, AwsError, UserID] =
      AwsError.unwrapOptionField("userId", userId)
    def getNumResults: ZIO[Any, AwsError, NumResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getContext: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("context", context)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFilterValues
        : ZIO[Any, AwsError, Map[FilterAttributeName, FilterAttributeValue]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ) extends zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly {
    override val campaignArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.campaignArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val itemId: Optional[ItemID] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.personalizeruntime.model.primitives.ItemID(value))
    override val userId: Optional[UserID] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.personalizeruntime.model.primitives.UserID(value))
    override val numResults: Optional[NumResults] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value =>
        zio.aws.personalizeruntime.model.primitives.NumResults(value)
      )
    override val context: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalizeruntime.model.primitives.AttributeName(
                key
              ) -> zio.aws.personalizeruntime.model.primitives
                .AttributeValue(value)
            })
            .toMap
        )
    override val filterArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val filterValues
        : Optional[Map[FilterAttributeName, FilterAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterValues())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.personalizeruntime.model.primitives.FilterAttributeName(
                key
              ) -> zio.aws.personalizeruntime.model.primitives
                .FilterAttributeValue(value)
            })
            .toMap
        )
    override val recommenderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ): zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
