package zio.aws.personalizeruntime
import zio.aws.core.config.AwsConfig
import zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.ReadOnly
import software.amazon.awssdk.services.personalizeruntime.{
  PersonalizeRuntimeAsyncClientBuilder,
  PersonalizeRuntimeAsyncClient
}
import software.amazon.awssdk.services.personalizeruntime.model.{
  GetRecommendationsResponse,
  GetRecommendationsRequest,
  GetPersonalizedRankingResponse,
  GetPersonalizedRankingRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait PersonalizeRuntime extends AspectSupport[PersonalizeRuntime] {
  val api: PersonalizeRuntimeAsyncClient
  def getPersonalizedRanking(
      request: zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest
  ): IO[AwsError, ReadOnly]
  def getRecommendations(
      request: zio.aws.personalizeruntime.model.GetRecommendationsRequest
  ): IO[
    AwsError,
    zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly
  ]
}
object PersonalizeRuntime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PersonalizeRuntime] =
    customized(identity)
  def customized(
      customization: PersonalizeRuntimeAsyncClientBuilder => PersonalizeRuntimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PersonalizeRuntime] = managed(
    customization
  ).toLayer
  def managed(
      customization: PersonalizeRuntimeAsyncClientBuilder => PersonalizeRuntimeAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, PersonalizeRuntime] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PersonalizeRuntimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        PersonalizeRuntimeAsyncClient,
        PersonalizeRuntimeAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        PersonalizeRuntimeAsyncClient,
        PersonalizeRuntimeAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new PersonalizeRuntimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PersonalizeRuntimeImpl[R](
      override val api: PersonalizeRuntimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PersonalizeRuntime
      with AwsServiceBase[R] {
    override val serviceName: String = "PersonalizeRuntime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PersonalizeRuntimeImpl[R1] =
      new PersonalizeRuntimeImpl(api, newAspect, r)
    def getPersonalizedRanking(
        request: zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      GetPersonalizedRankingRequest,
      GetPersonalizedRankingResponse
    ]("getPersonalizedRanking", api.getPersonalizedRanking)(
      request.buildAwsValue()
    ).map(zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.wrap)
      .provideEnvironment(r)
    def getRecommendations(
        request: zio.aws.personalizeruntime.model.GetRecommendationsRequest
    ): IO[
      AwsError,
      zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRecommendationsRequest,
      GetRecommendationsResponse
    ]("getRecommendations", api.getRecommendations)(request.buildAwsValue())
      .map(zio.aws.personalizeruntime.model.GetRecommendationsResponse.wrap)
      .provideEnvironment(r)
  }
  def getPersonalizedRanking(
      request: zio.aws.personalizeruntime.model.GetPersonalizedRankingRequest
  ): ZIO[zio.aws.personalizeruntime.PersonalizeRuntime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getPersonalizedRanking(request))
  def getRecommendations(
      request: zio.aws.personalizeruntime.model.GetRecommendationsRequest
  ): ZIO[
    zio.aws.personalizeruntime.PersonalizeRuntime,
    AwsError,
    zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecommendations(request))
}
