package zio.aws.personalizeruntime.model
import zio.aws.personalizeruntime.model.primitives.RecommendationID
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRecommendationsResponse(
    itemList: Option[Iterable[zio.aws.personalizeruntime.model.PredictedItem]] =
      None,
    recommendationId: Option[RecommendationID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse = {
    import GetRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse
      .builder()
      .optionallyWith(
        itemList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.itemList)
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationID.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .build()
  }
  def asReadOnly
      : zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly =
    zio.aws.personalizeruntime.model.GetRecommendationsResponse
      .wrap(buildAwsValue())
}
object GetRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalizeruntime.model.GetRecommendationsResponse =
      zio.aws.personalizeruntime.model.GetRecommendationsResponse(
        itemList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationId.map(value => value)
      )
    def itemList
        : Option[List[zio.aws.personalizeruntime.model.PredictedItem.ReadOnly]]
    def recommendationId: Option[RecommendationID]
    def getItemList: ZIO[Any, AwsError, List[
      zio.aws.personalizeruntime.model.PredictedItem.ReadOnly
    ]] = AwsError.unwrapOptionField("itemList", itemList)
    def getRecommendationId: ZIO[Any, AwsError, RecommendationID] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse
  ) extends zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly {
    override val itemList: Option[
      List[zio.aws.personalizeruntime.model.PredictedItem.ReadOnly]
    ] = scala
      .Option(impl.itemList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalizeruntime.model.PredictedItem.wrap(item)
        }.toList
      )
    override val recommendationId: Option[RecommendationID] = scala
      .Option(impl.recommendationId())
      .map(value =>
        zio.aws.personalizeruntime.model.primitives.RecommendationID(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse
  ): zio.aws.personalizeruntime.model.GetRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
