package zio.aws.personalizeruntime.model
import java.lang.Integer
import zio.aws.personalizeruntime.model.primitives.{
  FilterAttributeName,
  AttributeName,
  UserID,
  ItemID,
  FilterAttributeValue,
  Arn,
  NumResults,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRecommendationsRequest(
    campaignArn: Option[Arn] = None,
    itemId: Option[ItemID] = None,
    userId: Option[UserID] = None,
    numResults: Option[NumResults] = None,
    context: Option[Map[AttributeName, AttributeValue]] = None,
    filterArn: Option[Arn] = None,
    filterValues: Option[Map[FilterAttributeName, FilterAttributeValue]] = None,
    recommenderArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest = {
    import GetRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
      .builder()
      .optionallyWith(
        campaignArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.campaignArn)
      .optionallyWith(
        itemId.map(value => ItemID.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        userId.map(value => UserID.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        numResults.map(value => NumResults.unwrap(value): Integer)
      )(_.numResults)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        filterArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.filterArn)
      .optionallyWith(
        filterValues.map(value =>
          value
            .map({ case (key, value) =>
              (FilterAttributeName
                .unwrap(key): java.lang.String) -> (FilterAttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.filterValues)
      .optionallyWith(
        recommenderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.recommenderArn)
      .build()
  }
  def asReadOnly
      : zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly =
    zio.aws.personalizeruntime.model.GetRecommendationsRequest
      .wrap(buildAwsValue())
}
object GetRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeruntime.model.GetRecommendationsRequest =
      zio.aws.personalizeruntime.model.GetRecommendationsRequest(
        campaignArn.map(value => value),
        itemId.map(value => value),
        userId.map(value => value),
        numResults.map(value => value),
        context.map(value => value),
        filterArn.map(value => value),
        filterValues.map(value => value),
        recommenderArn.map(value => value)
      )
    def campaignArn: Option[Arn]
    def itemId: Option[ItemID]
    def userId: Option[UserID]
    def numResults: Option[NumResults]
    def context: Option[Map[AttributeName, AttributeValue]]
    def filterArn: Option[Arn]
    def filterValues: Option[Map[FilterAttributeName, FilterAttributeValue]]
    def recommenderArn: Option[Arn]
    def getCampaignArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("campaignArn", campaignArn)
    def getItemId: ZIO[Any, AwsError, ItemID] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getUserId: ZIO[Any, AwsError, UserID] =
      AwsError.unwrapOptionField("userId", userId)
    def getNumResults: ZIO[Any, AwsError, NumResults] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getContext: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("context", context)
    def getFilterArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("filterArn", filterArn)
    def getFilterValues
        : ZIO[Any, AwsError, Map[FilterAttributeName, FilterAttributeValue]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
    def getRecommenderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("recommenderArn", recommenderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ) extends zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly {
    override val campaignArn: Option[Arn] = scala
      .Option(impl.campaignArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val itemId: Option[ItemID] = scala
      .Option(impl.itemId())
      .map(value => zio.aws.personalizeruntime.model.primitives.ItemID(value))
    override val userId: Option[UserID] = scala
      .Option(impl.userId())
      .map(value => zio.aws.personalizeruntime.model.primitives.UserID(value))
    override val numResults: Option[NumResults] = scala
      .Option(impl.numResults())
      .map(value =>
        zio.aws.personalizeruntime.model.primitives.NumResults(value)
      )
    override val context: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.context())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalizeruntime.model.primitives
              .AttributeName(key) -> zio.aws.personalizeruntime.model.primitives
              .AttributeValue(value)
          })
          .toMap
      )
    override val filterArn: Option[Arn] = scala
      .Option(impl.filterArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
    override val filterValues
        : Option[Map[FilterAttributeName, FilterAttributeValue]] = scala
      .Option(impl.filterValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.personalizeruntime.model.primitives.FilterAttributeName(
              key
            ) -> zio.aws.personalizeruntime.model.primitives
              .FilterAttributeValue(value)
          })
          .toMap
      )
    override val recommenderArn: Option[Arn] = scala
      .Option(impl.recommenderArn())
      .map(value => zio.aws.personalizeruntime.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest
  ): zio.aws.personalizeruntime.model.GetRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
