package zio.aws.personalizeruntime.model
import zio.aws.personalizeruntime.model.primitives.RecommendationID
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPersonalizedRankingResponse(
    personalizedRanking: Option[
      Iterable[zio.aws.personalizeruntime.model.PredictedItem]
    ] = None,
    recommendationId: Option[RecommendationID] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse = {
    import GetPersonalizedRankingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse
      .builder()
      .optionallyWith(
        personalizedRanking.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.personalizedRanking)
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationID.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .build()
  }
  def asReadOnly
      : zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.ReadOnly =
    zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse
      .wrap(buildAwsValue())
}
object GetPersonalizedRankingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse =
      zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse(
        personalizedRanking.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationId.map(value => value)
      )
    def personalizedRanking
        : Option[List[zio.aws.personalizeruntime.model.PredictedItem.ReadOnly]]
    def recommendationId: Option[RecommendationID]
    def getPersonalizedRanking: ZIO[Any, AwsError, List[
      zio.aws.personalizeruntime.model.PredictedItem.ReadOnly
    ]] = AwsError.unwrapOptionField("personalizedRanking", personalizedRanking)
    def getRecommendationId: ZIO[Any, AwsError, RecommendationID] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse
  ) extends zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.ReadOnly {
    override val personalizedRanking: Option[
      List[zio.aws.personalizeruntime.model.PredictedItem.ReadOnly]
    ] = scala
      .Option(impl.personalizedRanking())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalizeruntime.model.PredictedItem.wrap(item)
        }.toList
      )
    override val recommendationId: Option[RecommendationID] = scala
      .Option(impl.recommendationId())
      .map(value =>
        zio.aws.personalizeruntime.model.primitives.RecommendationID(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse
  ): zio.aws.personalizeruntime.model.GetPersonalizedRankingResponse.ReadOnly =
    new Wrapper(impl)
}
