package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalizeevents.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class PutItemsRequest(
    datasetArn: Arn,
    items: Iterable[zio.aws.personalizeevents.model.Item]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest = {
    import PutItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.PutItemsRequest.ReadOnly =
    zio.aws.personalizeevents.model.PutItemsRequest.wrap(buildAwsValue())
}
object PutItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.PutItemsRequest =
      zio.aws.personalizeevents.model.PutItemsRequest(
        datasetArn,
        items.map { item =>
          item.asEditable
        }
      )
    def datasetArn: Arn
    def items: List[zio.aws.personalizeevents.model.Item.ReadOnly]
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.personalizeevents.model.Item.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest
  ) extends zio.aws.personalizeevents.model.PutItemsRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.personalizeevents.model.primitives.Arn(impl.datasetArn())
    override val items: List[zio.aws.personalizeevents.model.Item.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.personalizeevents.model.Item.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest
  ): zio.aws.personalizeevents.model.PutItemsRequest.ReadOnly = new Wrapper(
    impl
  )
}
