package zio.aws.personalizeevents.model
import zio.aws.personalizeevents.model.primitives.{
  FloatType,
  Date,
  EventPropertiesJSON,
  ItemId,
  RecommendationId,
  StringType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Event(
    eventId: Optional[StringType] = Optional.Absent,
    eventType: StringType,
    eventValue: Optional[FloatType] = Optional.Absent,
    itemId: Optional[ItemId] = Optional.Absent,
    properties: Optional[EventPropertiesJSON] = Optional.Absent,
    sentAt: Date,
    recommendationId: Optional[RecommendationId] = Optional.Absent,
    impression: Optional[Iterable[ItemId]] = Optional.Absent,
    metricAttribution: Optional[
      zio.aws.personalizeevents.model.MetricAttribution
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.Event
      .builder()
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .eventType(eventType: java.lang.String)
      .optionallyWith(
        eventValue.map(value => FloatType.unwrap(value): java.lang.Float)
      )(_.eventValue)
      .optionallyWith(
        itemId.map(value => ItemId.unwrap(value): java.lang.String)
      )(_.itemId)
      .optionallyWith(
        properties.map(value =>
          EventPropertiesJSON.unwrap(value): java.lang.String
        )
      )(_.properties)
      .sentAt(Date.unwrap(sentAt): Instant)
      .optionallyWith(
        recommendationId.map(value =>
          RecommendationId.unwrap(value): java.lang.String
        )
      )(_.recommendationId)
      .optionallyWith(
        impression.map(value =>
          value.map { item =>
            ItemId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.impression)
      .optionallyWith(metricAttribution.map(value => value.buildAwsValue()))(
        _.metricAttribution
      )
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.Event.ReadOnly =
    zio.aws.personalizeevents.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.Event
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.Event =
      zio.aws.personalizeevents.model.Event(
        eventId.map(value => value),
        eventType,
        eventValue.map(value => value),
        itemId.map(value => value),
        properties.map(value => value),
        sentAt,
        recommendationId.map(value => value),
        impression.map(value => value),
        metricAttribution.map(value => value.asEditable)
      )
    def eventId: Optional[StringType]
    def eventType: StringType
    def eventValue: Optional[FloatType]
    def itemId: Optional[ItemId]
    def properties: Optional[EventPropertiesJSON]
    def sentAt: Date
    def recommendationId: Optional[RecommendationId]
    def impression: Optional[List[ItemId]]
    def metricAttribution
        : Optional[zio.aws.personalizeevents.model.MetricAttribution.ReadOnly]
    def getEventId: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType: ZIO[Any, Nothing, StringType] = ZIO.succeed(eventType)
    def getEventValue: ZIO[Any, AwsError, FloatType] =
      AwsError.unwrapOptionField("eventValue", eventValue)
    def getItemId: ZIO[Any, AwsError, ItemId] =
      AwsError.unwrapOptionField("itemId", itemId)
    def getProperties: ZIO[Any, AwsError, EventPropertiesJSON] =
      AwsError.unwrapOptionField("properties", properties)
    def getSentAt: ZIO[Any, Nothing, Date] = ZIO.succeed(sentAt)
    def getRecommendationId: ZIO[Any, AwsError, RecommendationId] =
      AwsError.unwrapOptionField("recommendationId", recommendationId)
    def getImpression: ZIO[Any, AwsError, List[ItemId]] =
      AwsError.unwrapOptionField("impression", impression)
    def getMetricAttribution: ZIO[
      Any,
      AwsError,
      zio.aws.personalizeevents.model.MetricAttribution.ReadOnly
    ] = AwsError.unwrapOptionField("metricAttribution", metricAttribution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.Event
  ) extends zio.aws.personalizeevents.model.Event.ReadOnly {
    override val eventId: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => value: StringType)
    override val eventType: StringType = impl.eventType(): StringType
    override val eventValue: Optional[FloatType] = zio.aws.core.internal
      .optionalFromNullable(impl.eventValue())
      .map(value => zio.aws.personalizeevents.model.primitives.FloatType(value))
    override val itemId: Optional[ItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.itemId())
      .map(value => zio.aws.personalizeevents.model.primitives.ItemId(value))
    override val properties: Optional[EventPropertiesJSON] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          zio.aws.personalizeevents.model.primitives.EventPropertiesJSON(value)
        )
    override val sentAt: Date =
      zio.aws.personalizeevents.model.primitives.Date(impl.sentAt())
    override val recommendationId: Optional[RecommendationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationId())
        .map(value =>
          zio.aws.personalizeevents.model.primitives.RecommendationId(value)
        )
    override val impression: Optional[List[ItemId]] = zio.aws.core.internal
      .optionalFromNullable(impl.impression())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.personalizeevents.model.primitives.ItemId(item)
        }.toList
      )
    override val metricAttribution
        : Optional[zio.aws.personalizeevents.model.MetricAttribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricAttribution())
        .map(value =>
          zio.aws.personalizeevents.model.MetricAttribution.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.Event
  ): zio.aws.personalizeevents.model.Event.ReadOnly = new Wrapper(impl)
}
