package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalizeevents.model.primitives.EventAttributionSource
import scala.jdk.CollectionConverters.*
final case class MetricAttribution(
    eventAttributionSource: EventAttributionSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.MetricAttribution = {
    import MetricAttribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.MetricAttribution
      .builder()
      .eventAttributionSource(
        EventAttributionSource.unwrap(eventAttributionSource): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.MetricAttribution.ReadOnly =
    zio.aws.personalizeevents.model.MetricAttribution.wrap(buildAwsValue())
}
object MetricAttribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.MetricAttribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.MetricAttribution =
      zio.aws.personalizeevents.model.MetricAttribution(eventAttributionSource)
    def eventAttributionSource: EventAttributionSource
    def getEventAttributionSource: ZIO[Any, Nothing, EventAttributionSource] =
      ZIO.succeed(eventAttributionSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.MetricAttribution
  ) extends zio.aws.personalizeevents.model.MetricAttribution.ReadOnly {
    override val eventAttributionSource: EventAttributionSource =
      zio.aws.personalizeevents.model.primitives
        .EventAttributionSource(impl.eventAttributionSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.MetricAttribution
  ): zio.aws.personalizeevents.model.MetricAttribution.ReadOnly = new Wrapper(
    impl
  )
}
