package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.personalizeevents.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class PutUsersRequest(
    datasetArn: Arn,
    users: Iterable[zio.aws.personalizeevents.model.User]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest = {
    import PutUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.PutUsersRequest.ReadOnly =
    zio.aws.personalizeevents.model.PutUsersRequest.wrap(buildAwsValue())
}
object PutUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.PutUsersRequest =
      zio.aws.personalizeevents.model.PutUsersRequest(
        datasetArn,
        users.map { item =>
          item.asEditable
        }
      )
    def datasetArn: Arn
    def users: List[zio.aws.personalizeevents.model.User.ReadOnly]
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
    def getUsers: ZIO[Any, Nothing, List[
      zio.aws.personalizeevents.model.User.ReadOnly
    ]] = ZIO.succeed(users)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest
  ) extends zio.aws.personalizeevents.model.PutUsersRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.personalizeevents.model.primitives.Arn(impl.datasetArn())
    override val users: List[zio.aws.personalizeevents.model.User.ReadOnly] =
      impl
        .users()
        .asScala
        .map { item =>
          zio.aws.personalizeevents.model.User.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest
  ): zio.aws.personalizeevents.model.PutUsersRequest.ReadOnly = new Wrapper(
    impl
  )
}
