package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.personalizeevents.model.primitives.{UserId, StringType}
import scala.jdk.CollectionConverters.*
final case class PutEventsRequest(
    trackingId: StringType,
    userId: Optional[UserId] = Optional.Absent,
    sessionId: StringType,
    eventList: Iterable[zio.aws.personalizeevents.model.Event]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest = {
    import PutEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
      .builder()
      .trackingId(trackingId: java.lang.String)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .sessionId(sessionId: java.lang.String)
      .eventList(eventList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly =
    zio.aws.personalizeevents.model.PutEventsRequest.wrap(buildAwsValue())
}
object PutEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.PutEventsRequest =
      zio.aws.personalizeevents.model.PutEventsRequest(
        trackingId,
        userId.map(value => value),
        sessionId,
        eventList.map { item =>
          item.asEditable
        }
      )
    def trackingId: StringType
    def userId: Optional[UserId]
    def sessionId: StringType
    def eventList: List[zio.aws.personalizeevents.model.Event.ReadOnly]
    def getTrackingId: ZIO[Any, Nothing, StringType] = ZIO.succeed(trackingId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getSessionId: ZIO[Any, Nothing, StringType] = ZIO.succeed(sessionId)
    def getEventList: ZIO[Any, Nothing, List[
      zio.aws.personalizeevents.model.Event.ReadOnly
    ]] = ZIO.succeed(eventList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ) extends zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly {
    override val trackingId: StringType = impl.trackingId(): StringType
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.personalizeevents.model.primitives.UserId(value))
    override val sessionId: StringType = impl.sessionId(): StringType
    override val eventList
        : List[zio.aws.personalizeevents.model.Event.ReadOnly] = impl
      .eventList()
      .asScala
      .map { item =>
        zio.aws.personalizeevents.model.Event.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ): zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
