package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.personalizeevents.model.primitives.{ItemProperties, StringType}
import scala.jdk.CollectionConverters.*
final case class Item(
    itemId: StringType,
    properties: Optional[ItemProperties] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.Item = {
    import Item.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.Item
      .builder()
      .itemId(itemId: java.lang.String)
      .optionallyWith(
        properties.map(value => ItemProperties.unwrap(value): java.lang.String)
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.Item.ReadOnly =
    zio.aws.personalizeevents.model.Item.wrap(buildAwsValue())
}
object Item {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.Item
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.Item =
      zio.aws.personalizeevents.model
        .Item(itemId, properties.map(value => value))
    def itemId: StringType
    def properties: Optional[ItemProperties]
    def getItemId: ZIO[Any, Nothing, StringType] = ZIO.succeed(itemId)
    def getProperties: ZIO[Any, AwsError, ItemProperties] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.Item
  ) extends zio.aws.personalizeevents.model.Item.ReadOnly {
    override val itemId: StringType = impl.itemId(): StringType
    override val properties: Optional[ItemProperties] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        zio.aws.personalizeevents.model.primitives.ItemProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.Item
  ): zio.aws.personalizeevents.model.Item.ReadOnly = new Wrapper(impl)
}
