package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalizeevents.model.primitives.{UserProperties, StringType}
import scala.jdk.CollectionConverters.*
final case class User(
    userId: StringType,
    properties: Option[UserProperties] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.User
      .builder()
      .userId(userId: java.lang.String)
      .optionallyWith(
        properties.map(value => UserProperties.unwrap(value): java.lang.String)
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.User.ReadOnly =
    zio.aws.personalizeevents.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.User
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.User =
      zio.aws.personalizeevents.model
        .User(userId, properties.map(value => value))
    def userId: StringType
    def properties: Option[UserProperties]
    def getUserId: ZIO[Any, Nothing, StringType] = ZIO.succeed(userId)
    def getProperties: ZIO[Any, AwsError, UserProperties] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.User
  ) extends zio.aws.personalizeevents.model.User.ReadOnly {
    override val userId: StringType = impl.userId(): StringType
    override val properties: Option[UserProperties] = scala
      .Option(impl.properties())
      .map(value =>
        zio.aws.personalizeevents.model.primitives.UserProperties(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.User
  ): zio.aws.personalizeevents.model.User.ReadOnly = new Wrapper(impl)
}
