package zio.aws.personalizeevents
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.personalizeevents.{
  PersonalizeEventsAsyncClientBuilder,
  PersonalizeEventsAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.personalizeevents.model.{
  PutItemsResponse,
  PutItemsRequest,
  PutUsersResponse,
  PutUsersRequest,
  PutEventsResponse,
  PutEventsRequest
}
import scala.jdk.CollectionConverters.*
trait PersonalizeEvents extends AspectSupport[PersonalizeEvents] {
  val api: PersonalizeEventsAsyncClient
  def putEvents(
      request: zio.aws.personalizeevents.model.PutEventsRequest
  ): IO[AwsError, Unit]
  def putItems(
      request: zio.aws.personalizeevents.model.PutItemsRequest
  ): IO[AwsError, Unit]
  def putUsers(
      request: zio.aws.personalizeevents.model.PutUsersRequest
  ): IO[AwsError, Unit]
}
object PersonalizeEvents {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PersonalizeEvents] =
    customized(identity)
  def customized(
      customization: PersonalizeEventsAsyncClientBuilder => PersonalizeEventsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PersonalizeEvents] = managed(
    customization
  ).toLayer
  def managed(
      customization: PersonalizeEventsAsyncClientBuilder => PersonalizeEventsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, PersonalizeEvents] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PersonalizeEventsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        PersonalizeEventsAsyncClient,
        PersonalizeEventsAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        PersonalizeEventsAsyncClient,
        PersonalizeEventsAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new PersonalizeEventsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PersonalizeEventsImpl[R](
      override val api: PersonalizeEventsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PersonalizeEvents
      with AwsServiceBase[R] {
    override val serviceName: String = "PersonalizeEvents"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PersonalizeEventsImpl[R1] = new PersonalizeEventsImpl(api, newAspect, r)
    def putEvents(
        request: zio.aws.personalizeevents.model.PutEventsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutEventsRequest, PutEventsResponse](
        "putEvents",
        api.putEvents
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putItems(
        request: zio.aws.personalizeevents.model.PutItemsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutItemsRequest, PutItemsResponse](
        "putItems",
        api.putItems
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putUsers(
        request: zio.aws.personalizeevents.model.PutUsersRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutUsersRequest, PutUsersResponse](
        "putUsers",
        api.putUsers
      )(request.buildAwsValue()).unit.provideEnvironment(r)
  }
  def putEvents(
      request: zio.aws.personalizeevents.model.PutEventsRequest
  ): ZIO[zio.aws.personalizeevents.PersonalizeEvents, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putEvents(request))
  def putItems(
      request: zio.aws.personalizeevents.model.PutItemsRequest
  ): ZIO[zio.aws.personalizeevents.PersonalizeEvents, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putItems(request))
  def putUsers(
      request: zio.aws.personalizeevents.model.PutUsersRequest
  ): ZIO[zio.aws.personalizeevents.PersonalizeEvents, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putUsers(request))
}
