package zio.aws.personalizeevents.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.personalizeevents.model.primitives.{UserId, StringType}
import scala.jdk.CollectionConverters.*
final case class PutEventsRequest(
    trackingId: StringType,
    userId: Option[UserId] = None,
    sessionId: StringType,
    eventList: Iterable[zio.aws.personalizeevents.model.Event]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest = {
    import PutEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
      .builder()
      .trackingId(StringType.unwrap(trackingId): java.lang.String)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .sessionId(StringType.unwrap(sessionId): java.lang.String)
      .eventList(eventList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly =
    zio.aws.personalizeevents.model.PutEventsRequest.wrap(buildAwsValue())
}
object PutEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.personalizeevents.model.PutEventsRequest =
      zio.aws.personalizeevents.model.PutEventsRequest(
        trackingId,
        userId.map(value => value),
        sessionId,
        eventList.map { item =>
          item.asEditable
        }
      )
    def trackingId: StringType
    def userId: Option[UserId]
    def sessionId: StringType
    def eventList: List[zio.aws.personalizeevents.model.Event.ReadOnly]
    def getTrackingId: ZIO[Any, Nothing, StringType] = ZIO.succeed(trackingId)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getSessionId: ZIO[Any, Nothing, StringType] = ZIO.succeed(sessionId)
    def getEventList: ZIO[Any, Nothing, List[
      zio.aws.personalizeevents.model.Event.ReadOnly
    ]] = ZIO.succeed(eventList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ) extends zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly {
    override val trackingId: StringType =
      zio.aws.personalizeevents.model.primitives.StringType(impl.trackingId())
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.personalizeevents.model.primitives.UserId(value))
    override val sessionId: StringType =
      zio.aws.personalizeevents.model.primitives.StringType(impl.sessionId())
    override val eventList
        : List[zio.aws.personalizeevents.model.Event.ReadOnly] = impl
      .eventList()
      .asScala
      .map { item =>
        zio.aws.personalizeevents.model.Event.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest
  ): zio.aws.personalizeevents.model.PutEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
