package zio.aws.personalizeevents
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.personalizeevents.PersonalizeEventsAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.personalizeevents.model.{
  PutUsersRequest,
  PutItemsRequest,
  PutEventsRequest
}
object PersonalizeEventsMock extends Mock[PersonalizeEvents] {
  object PutEvents extends Effect[PutEventsRequest, AwsError, Unit]
  object PutItems extends Effect[PutItemsRequest, AwsError, Unit]
  object PutUsers extends Effect[PutUsersRequest, AwsError, Unit]
  val compose: URLayer[Proxy, PersonalizeEvents] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new PersonalizeEvents {
          val api: PersonalizeEventsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : PersonalizeEvents = this
          def putEvents(request: PutEventsRequest): IO[AwsError, Unit] =
            proxy(PutEvents, request)
          def putItems(request: PutItemsRequest): IO[AwsError, Unit] =
            proxy(PutItems, request)
          def putUsers(request: PutUsersRequest): IO[AwsError, Unit] =
            proxy(PutUsers, request)
        }
      }
    }
    .toLayer
}
