package zio.aws.paymentcryptographydata.model
import java.lang.Integer
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween4And12,
  IntegerRangeBetween0And9
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VisaPinVerification(
    pinVerificationKeyIndex: IntegerRangeBetween0And9,
    verificationValue: NumberLengthBetween4And12
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification = {
    import VisaPinVerification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification
      .builder()
      .pinVerificationKeyIndex(
        IntegerRangeBetween0And9.unwrap(pinVerificationKeyIndex): Integer
      )
      .verificationValue(
        NumberLengthBetween4And12.unwrap(verificationValue): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly =
    zio.aws.paymentcryptographydata.model.VisaPinVerification
      .wrap(buildAwsValue())
}
object VisaPinVerification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.VisaPinVerification =
      zio.aws.paymentcryptographydata.model
        .VisaPinVerification(pinVerificationKeyIndex, verificationValue)
    def pinVerificationKeyIndex: IntegerRangeBetween0And9
    def verificationValue: NumberLengthBetween4And12
    def getPinVerificationKeyIndex
        : ZIO[Any, Nothing, IntegerRangeBetween0And9] =
      ZIO.succeed(pinVerificationKeyIndex)
    def getVerificationValue: ZIO[Any, Nothing, NumberLengthBetween4And12] =
      ZIO.succeed(verificationValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification
  ) extends zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly {
    override val pinVerificationKeyIndex: IntegerRangeBetween0And9 =
      zio.aws.paymentcryptographydata.model.primitives
        .IntegerRangeBetween0And9(impl.pinVerificationKeyIndex())
    override val verificationValue: NumberLengthBetween4And12 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween4And12(impl.verificationValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPinVerification
  ): zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly =
    new Wrapper(impl)
}
