package zio.aws.paymentcryptographydata.model
import java.lang.Integer
import zio.aws.paymentcryptographydata.model.primitives.IntegerRangeBetween0And9
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VisaPin(pinVerificationKeyIndex: IntegerRangeBetween0And9) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin = {
    import VisaPin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin
      .builder()
      .pinVerificationKeyIndex(
        IntegerRangeBetween0And9.unwrap(pinVerificationKeyIndex): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly =
    zio.aws.paymentcryptographydata.model.VisaPin.wrap(buildAwsValue())
}
object VisaPin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.VisaPin =
      zio.aws.paymentcryptographydata.model.VisaPin(pinVerificationKeyIndex)
    def pinVerificationKeyIndex: IntegerRangeBetween0And9
    def getPinVerificationKeyIndex
        : ZIO[Any, Nothing, IntegerRangeBetween0And9] =
      ZIO.succeed(pinVerificationKeyIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin
  ) extends zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly {
    override val pinVerificationKeyIndex: IntegerRangeBetween0And9 =
      zio.aws.paymentcryptographydata.model.primitives
        .IntegerRangeBetween0And9(impl.pinVerificationKeyIndex())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VisaPin
  ): zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly = new Wrapper(impl)
}
