package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{KeyCheckValue, KeyArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyPinDataResponse(
    encryptionKeyArn: KeyArn,
    encryptionKeyCheckValue: KeyCheckValue,
    verificationKeyArn: KeyArn,
    verificationKeyCheckValue: KeyCheckValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse = {
    import VerifyPinDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse
      .builder()
      .encryptionKeyArn(KeyArn.unwrap(encryptionKeyArn): java.lang.String)
      .encryptionKeyCheckValue(
        KeyCheckValue.unwrap(encryptionKeyCheckValue): java.lang.String
      )
      .verificationKeyArn(KeyArn.unwrap(verificationKeyArn): java.lang.String)
      .verificationKeyCheckValue(
        KeyCheckValue.unwrap(verificationKeyCheckValue): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyPinDataResponse
      .wrap(buildAwsValue())
}
object VerifyPinDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.VerifyPinDataResponse =
      zio.aws.paymentcryptographydata.model.VerifyPinDataResponse(
        encryptionKeyArn,
        encryptionKeyCheckValue,
        verificationKeyArn,
        verificationKeyCheckValue
      )
    def encryptionKeyArn: KeyArn
    def encryptionKeyCheckValue: KeyCheckValue
    def verificationKeyArn: KeyArn
    def verificationKeyCheckValue: KeyCheckValue
    def getEncryptionKeyArn: ZIO[Any, Nothing, KeyArn] =
      ZIO.succeed(encryptionKeyArn)
    def getEncryptionKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(encryptionKeyCheckValue)
    def getVerificationKeyArn: ZIO[Any, Nothing, KeyArn] =
      ZIO.succeed(verificationKeyArn)
    def getVerificationKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(verificationKeyCheckValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse
  ) extends zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly {
    override val encryptionKeyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArn(impl.encryptionKeyArn())
    override val encryptionKeyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.encryptionKeyCheckValue())
    override val verificationKeyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArn(impl.verificationKeyArn())
    override val verificationKeyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.verificationKeyCheckValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataResponse
  ): zio.aws.paymentcryptographydata.model.VerifyPinDataResponse.ReadOnly =
    new Wrapper(impl)
}
