package zio.aws.paymentcryptographydata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  IntegerRangeBetween4And12,
  KeyArnOrKeyAliasType,
  HexLengthBetween16And32
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VerifyPinDataRequest(
    dukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptAttributes
    ] = Optional.Absent,
    encryptedPinBlock: HexLengthBetween16And32,
    encryptionKeyIdentifier: KeyArnOrKeyAliasType,
    pinBlockFormat: zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData,
    pinDataLength: Optional[IntegerRangeBetween4And12] = Optional.Absent,
    primaryAccountNumber: NumberLengthBetween12And19,
    verificationAttributes: zio.aws.paymentcryptographydata.model.PinVerificationAttributes,
    verificationKeyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest = {
    import VerifyPinDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest
      .builder()
      .optionallyWith(dukptAttributes.map(value => value.buildAwsValue()))(
        _.dukptAttributes
      )
      .encryptedPinBlock(
        HexLengthBetween16And32.unwrap(encryptedPinBlock): java.lang.String
      )
      .encryptionKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(encryptionKeyIdentifier): java.lang.String
      )
      .pinBlockFormat(pinBlockFormat.unwrap)
      .optionallyWith(
        pinDataLength.map(value =>
          IntegerRangeBetween4And12.unwrap(value): Integer
        )
      )(_.pinDataLength)
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .verificationAttributes(verificationAttributes.buildAwsValue())
      .verificationKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(verificationKeyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyPinDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyPinDataRequest
      .wrap(buildAwsValue())
}
object VerifyPinDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.VerifyPinDataRequest =
      zio.aws.paymentcryptographydata.model.VerifyPinDataRequest(
        dukptAttributes.map(value => value.asEditable),
        encryptedPinBlock,
        encryptionKeyIdentifier,
        pinBlockFormat,
        pinDataLength.map(value => value),
        primaryAccountNumber,
        verificationAttributes.asEditable,
        verificationKeyIdentifier
      )
    def dukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly
    ]
    def encryptedPinBlock: HexLengthBetween16And32
    def encryptionKeyIdentifier: KeyArnOrKeyAliasType
    def pinBlockFormat
        : zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
    def pinDataLength: Optional[IntegerRangeBetween4And12]
    def primaryAccountNumber: NumberLengthBetween12And19
    def verificationAttributes
        : zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly
    def verificationKeyIdentifier: KeyArnOrKeyAliasType
    def getDukptAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("dukptAttributes", dukptAttributes)
    def getEncryptedPinBlock: ZIO[Any, Nothing, HexLengthBetween16And32] =
      ZIO.succeed(encryptedPinBlock)
    def getEncryptionKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(encryptionKeyIdentifier)
    def getPinBlockFormat: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
    ] = ZIO.succeed(pinBlockFormat)
    def getPinDataLength: ZIO[Any, AwsError, IntegerRangeBetween4And12] =
      AwsError.unwrapOptionField("pinDataLength", pinDataLength)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
    def getVerificationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly
    ] = ZIO.succeed(verificationAttributes)
    def getVerificationKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(verificationKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest
  ) extends zio.aws.paymentcryptographydata.model.VerifyPinDataRequest.ReadOnly {
    override val dukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dukptAttributes())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DukptAttributes.wrap(value)
      )
    override val encryptedPinBlock: HexLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween16And32(impl.encryptedPinBlock())
    override val encryptionKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.encryptionKeyIdentifier())
    override val pinBlockFormat
        : zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData =
      zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData
        .wrap(impl.pinBlockFormat())
    override val pinDataLength: Optional[IntegerRangeBetween4And12] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pinDataLength())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .IntegerRangeBetween4And12(value)
        )
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
    override val verificationAttributes
        : zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.PinVerificationAttributes
        .wrap(impl.verificationAttributes())
    override val verificationKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.verificationKeyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyPinDataRequest
  ): zio.aws.paymentcryptographydata.model.VerifyPinDataRequest.ReadOnly =
    new Wrapper(impl)
}
