package zio.aws.paymentcryptographydata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptographydata.model.primitives.{
  HexEvenLengthBetween2And4096,
  IntegerRangeBetween4And16,
  HexEvenLengthBetween4And128,
  KeyArnOrKeyAliasType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VerifyMacRequest(
    keyIdentifier: KeyArnOrKeyAliasType,
    mac: HexEvenLengthBetween4And128,
    macLength: Optional[IntegerRangeBetween4And16] = Optional.Absent,
    messageData: HexEvenLengthBetween2And4096,
    verificationAttributes: zio.aws.paymentcryptographydata.model.MacAttributes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest = {
    import VerifyMacRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .mac(HexEvenLengthBetween4And128.unwrap(mac): java.lang.String)
      .optionallyWith(
        macLength.map(value => IntegerRangeBetween4And16.unwrap(value): Integer)
      )(_.macLength)
      .messageData(
        HexEvenLengthBetween2And4096.unwrap(messageData): java.lang.String
      )
      .verificationAttributes(verificationAttributes.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.VerifyMacRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.VerifyMacRequest.wrap(buildAwsValue())
}
object VerifyMacRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.VerifyMacRequest =
      zio.aws.paymentcryptographydata.model.VerifyMacRequest(
        keyIdentifier,
        mac,
        macLength.map(value => value),
        messageData,
        verificationAttributes.asEditable
      )
    def keyIdentifier: KeyArnOrKeyAliasType
    def mac: HexEvenLengthBetween4And128
    def macLength: Optional[IntegerRangeBetween4And16]
    def messageData: HexEvenLengthBetween2And4096
    def verificationAttributes
        : zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
    def getMac: ZIO[Any, Nothing, HexEvenLengthBetween4And128] =
      ZIO.succeed(mac)
    def getMacLength: ZIO[Any, AwsError, IntegerRangeBetween4And16] =
      AwsError.unwrapOptionField("macLength", macLength)
    def getMessageData: ZIO[Any, Nothing, HexEvenLengthBetween2And4096] =
      ZIO.succeed(messageData)
    def getVerificationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly
    ] = ZIO.succeed(verificationAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest
  ) extends zio.aws.paymentcryptographydata.model.VerifyMacRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
    override val mac: HexEvenLengthBetween4And128 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween4And128(impl.mac())
    override val macLength: Optional[IntegerRangeBetween4And16] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macLength())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .IntegerRangeBetween4And16(value)
        )
    override val messageData: HexEvenLengthBetween2And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween2And4096(impl.messageData())
    override val verificationAttributes
        : zio.aws.paymentcryptographydata.model.MacAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.MacAttributes
        .wrap(impl.verificationAttributes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.VerifyMacRequest
  ): zio.aws.paymentcryptographydata.model.VerifyMacRequest.ReadOnly =
    new Wrapper(impl)
}
