package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween16And32,
  KeyCheckValue,
  KeyArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TranslatePinDataResponse(
    keyArn: KeyArn,
    keyCheckValue: KeyCheckValue,
    pinBlock: HexLengthBetween16And32
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse = {
    import TranslatePinDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse
      .builder()
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .pinBlock(HexLengthBetween16And32.unwrap(pinBlock): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly =
    zio.aws.paymentcryptographydata.model.TranslatePinDataResponse
      .wrap(buildAwsValue())
}
object TranslatePinDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.TranslatePinDataResponse =
      zio.aws.paymentcryptographydata.model
        .TranslatePinDataResponse(keyArn, keyCheckValue, pinBlock)
    def keyArn: KeyArn
    def keyCheckValue: KeyCheckValue
    def pinBlock: HexLengthBetween16And32
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getPinBlock: ZIO[Any, Nothing, HexLengthBetween16And32] =
      ZIO.succeed(pinBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse
  ) extends zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly {
    override val keyArn: KeyArn =
      zio.aws.paymentcryptographydata.model.primitives.KeyArn(impl.keyArn())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val pinBlock: HexLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween16And32(impl.pinBlock())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataResponse
  ): zio.aws.paymentcryptographydata.model.TranslatePinDataResponse.ReadOnly =
    new Wrapper(impl)
}
