package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyArnOrKeyAliasType,
  HexEvenLengthBetween16And32
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TranslatePinDataRequest(
    encryptedPinBlock: HexEvenLengthBetween16And32,
    incomingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes
    ] = Optional.Absent,
    incomingKeyIdentifier: KeyArnOrKeyAliasType,
    incomingTranslationAttributes: zio.aws.paymentcryptographydata.model.TranslationIsoFormats,
    outgoingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes
    ] = Optional.Absent,
    outgoingKeyIdentifier: KeyArnOrKeyAliasType,
    outgoingTranslationAttributes: zio.aws.paymentcryptographydata.model.TranslationIsoFormats
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest = {
    import TranslatePinDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest
      .builder()
      .encryptedPinBlock(
        HexEvenLengthBetween16And32.unwrap(encryptedPinBlock): java.lang.String
      )
      .optionallyWith(
        incomingDukptAttributes.map(value => value.buildAwsValue())
      )(_.incomingDukptAttributes)
      .incomingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(incomingKeyIdentifier): java.lang.String
      )
      .incomingTranslationAttributes(
        incomingTranslationAttributes.buildAwsValue()
      )
      .optionallyWith(
        outgoingDukptAttributes.map(value => value.buildAwsValue())
      )(_.outgoingDukptAttributes)
      .outgoingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(outgoingKeyIdentifier): java.lang.String
      )
      .outgoingTranslationAttributes(
        outgoingTranslationAttributes.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.TranslatePinDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.TranslatePinDataRequest
      .wrap(buildAwsValue())
}
object TranslatePinDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.TranslatePinDataRequest =
      zio.aws.paymentcryptographydata.model.TranslatePinDataRequest(
        encryptedPinBlock,
        incomingDukptAttributes.map(value => value.asEditable),
        incomingKeyIdentifier,
        incomingTranslationAttributes.asEditable,
        outgoingDukptAttributes.map(value => value.asEditable),
        outgoingKeyIdentifier,
        outgoingTranslationAttributes.asEditable
      )
    def encryptedPinBlock: HexEvenLengthBetween16And32
    def incomingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ]
    def incomingKeyIdentifier: KeyArnOrKeyAliasType
    def incomingTranslationAttributes
        : zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly
    def outgoingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ]
    def outgoingKeyIdentifier: KeyArnOrKeyAliasType
    def outgoingTranslationAttributes
        : zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly
    def getEncryptedPinBlock: ZIO[Any, Nothing, HexEvenLengthBetween16And32] =
      ZIO.succeed(encryptedPinBlock)
    def getIncomingDukptAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "incomingDukptAttributes",
      incomingDukptAttributes
    )
    def getIncomingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(incomingKeyIdentifier)
    def getIncomingTranslationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly
    ] = ZIO.succeed(incomingTranslationAttributes)
    def getOutgoingDukptAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "outgoingDukptAttributes",
      outgoingDukptAttributes
    )
    def getOutgoingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(outgoingKeyIdentifier)
    def getOutgoingTranslationAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly
    ] = ZIO.succeed(outgoingTranslationAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest
  ) extends zio.aws.paymentcryptographydata.model.TranslatePinDataRequest.ReadOnly {
    override val encryptedPinBlock: HexEvenLengthBetween16And32 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And32(impl.encryptedPinBlock())
    override val incomingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.incomingDukptAttributes())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DukptDerivationAttributes
          .wrap(value)
      )
    override val incomingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.incomingKeyIdentifier())
    override val incomingTranslationAttributes
        : zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly =
      zio.aws.paymentcryptographydata.model.TranslationIsoFormats
        .wrap(impl.incomingTranslationAttributes())
    override val outgoingDukptAttributes: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outgoingDukptAttributes())
      .map(value =>
        zio.aws.paymentcryptographydata.model.DukptDerivationAttributes
          .wrap(value)
      )
    override val outgoingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.outgoingKeyIdentifier())
    override val outgoingTranslationAttributes
        : zio.aws.paymentcryptographydata.model.TranslationIsoFormats.ReadOnly =
      zio.aws.paymentcryptographydata.model.TranslationIsoFormats
        .wrap(impl.outgoingTranslationAttributes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.TranslatePinDataRequest
  ): zio.aws.paymentcryptographydata.model.TranslatePinDataRequest.ReadOnly =
    new Wrapper(impl)
}
