package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.HexLength16Or32
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SymmetricEncryptionAttributes(
    initializationVector: Optional[HexLength16Or32] = Optional.Absent,
    mode: zio.aws.paymentcryptographydata.model.EncryptionMode,
    paddingType: Optional[zio.aws.paymentcryptographydata.model.PaddingType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes = {
    import SymmetricEncryptionAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes
      .builder()
      .optionallyWith(
        initializationVector.map(value =>
          HexLength16Or32.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .mode(mode.unwrap)
      .optionallyWith(paddingType.map(value => value.unwrap))(_.paddingType)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes
      .wrap(buildAwsValue())
}
object SymmetricEncryptionAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes =
      zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes(
        initializationVector.map(value => value),
        mode,
        paddingType.map(value => value)
      )
    def initializationVector: Optional[HexLength16Or32]
    def mode: zio.aws.paymentcryptographydata.model.EncryptionMode
    def paddingType: Optional[zio.aws.paymentcryptographydata.model.PaddingType]
    def getInitializationVector: ZIO[Any, AwsError, HexLength16Or32] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
    def getMode: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.EncryptionMode
    ] = ZIO.succeed(mode)
    def getPaddingType: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.PaddingType
    ] = AwsError.unwrapOptionField("paddingType", paddingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes
  ) extends zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly {
    override val initializationVector: Optional[HexLength16Or32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initializationVector())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .HexLength16Or32(value)
        )
    override val mode: zio.aws.paymentcryptographydata.model.EncryptionMode =
      zio.aws.paymentcryptographydata.model.EncryptionMode.wrap(impl.mode())
    override val paddingType
        : Optional[zio.aws.paymentcryptographydata.model.PaddingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.paddingType())
        .map(value =>
          zio.aws.paymentcryptographydata.model.PaddingType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SymmetricEncryptionAttributes
  ): zio.aws.paymentcryptographydata.model.SymmetricEncryptionAttributes.ReadOnly =
    new Wrapper(impl)
}
