package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And8,
  NumberLengthBetween12And19,
  HexLengthEquals2,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SessionKeyMastercard(
    applicationTransactionCounter: HexLengthBetween2And4,
    panSequenceNumber: HexLengthEquals2,
    primaryAccountNumber: NumberLengthBetween12And19,
    unpredictableNumber: HexLengthBetween2And8
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard = {
    import SessionKeyMastercard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .unpredictableNumber(
        HexLengthBetween2And8.unwrap(unpredictableNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyMastercard
      .wrap(buildAwsValue())
}
object SessionKeyMastercard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.SessionKeyMastercard =
      zio.aws.paymentcryptographydata.model.SessionKeyMastercard(
        applicationTransactionCounter,
        panSequenceNumber,
        primaryAccountNumber,
        unpredictableNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def panSequenceNumber: HexLengthEquals2
    def primaryAccountNumber: NumberLengthBetween12And19
    def unpredictableNumber: HexLengthBetween2And8
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
    def getUnpredictableNumber: ZIO[Any, Nothing, HexLengthBetween2And8] =
      ZIO.succeed(unpredictableNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
    override val unpredictableNumber: HexLengthBetween2And8 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And8(impl.unpredictableNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard
  ): zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly =
    new Wrapper(impl)
}
