package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  HexLengthEquals2,
  HexLengthBetween2And4
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SessionKeyEmvCommon(
    applicationTransactionCounter: HexLengthBetween2And4,
    panSequenceNumber: HexLengthEquals2,
    primaryAccountNumber: NumberLengthBetween12And19
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon = {
    import SessionKeyEmvCommon.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon
      .builder()
      .applicationTransactionCounter(
        HexLengthBetween2And4.unwrap(
          applicationTransactionCounter
        ): java.lang.String
      )
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon
      .wrap(buildAwsValue())
}
object SessionKeyEmvCommon {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon =
      zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon(
        applicationTransactionCounter,
        panSequenceNumber,
        primaryAccountNumber
      )
    def applicationTransactionCounter: HexLengthBetween2And4
    def panSequenceNumber: HexLengthEquals2
    def primaryAccountNumber: NumberLengthBetween12And19
    def getApplicationTransactionCounter
        : ZIO[Any, Nothing, HexLengthBetween2And4] =
      ZIO.succeed(applicationTransactionCounter)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly {
    override val applicationTransactionCounter: HexLengthBetween2And4 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween2And4(impl.applicationTransactionCounter())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon
  ): zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly =
    new Wrapper(impl)
}
