package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  HexLengthBetween2And4,
  HexLengthEquals16
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SessionKeyDerivationValue(
    applicationCryptogram: Optional[HexLengthEquals16] = Optional.Absent,
    applicationTransactionCounter: Optional[HexLengthBetween2And4] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue = {
    import SessionKeyDerivationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue
      .builder()
      .optionallyWith(
        applicationCryptogram.map(value =>
          HexLengthEquals16.unwrap(value): java.lang.String
        )
      )(_.applicationCryptogram)
      .optionallyWith(
        applicationTransactionCounter.map(value =>
          HexLengthBetween2And4.unwrap(value): java.lang.String
        )
      )(_.applicationTransactionCounter)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue
      .wrap(buildAwsValue())
}
object SessionKeyDerivationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue =
      zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue(
        applicationCryptogram.map(value => value),
        applicationTransactionCounter.map(value => value)
      )
    def applicationCryptogram: Optional[HexLengthEquals16]
    def applicationTransactionCounter: Optional[HexLengthBetween2And4]
    def getApplicationCryptogram: ZIO[Any, AwsError, HexLengthEquals16] =
      AwsError.unwrapOptionField("applicationCryptogram", applicationCryptogram)
    def getApplicationTransactionCounter
        : ZIO[Any, AwsError, HexLengthBetween2And4] =
      AwsError.unwrapOptionField(
        "applicationTransactionCounter",
        applicationTransactionCounter
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly {
    override val applicationCryptogram: Optional[HexLengthEquals16] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationCryptogram())
        .map(value =>
          zio.aws.paymentcryptographydata.model.primitives
            .HexLengthEquals16(value)
        )
    override val applicationTransactionCounter
        : Optional[HexLengthBetween2And4] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationTransactionCounter())
      .map(value =>
        zio.aws.paymentcryptographydata.model.primitives
          .HexLengthBetween2And4(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivationValue
  ): zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly =
    new Wrapper(impl)
}
