package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SessionKeyDerivation(
    amex: Optional[zio.aws.paymentcryptographydata.model.SessionKeyAmex] =
      Optional.Absent,
    emv2000: Optional[zio.aws.paymentcryptographydata.model.SessionKeyEmv2000] =
      Optional.Absent,
    emvCommon: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon
    ] = Optional.Absent,
    mastercard: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyMastercard
    ] = Optional.Absent,
    visa: Optional[zio.aws.paymentcryptographydata.model.SessionKeyVisa] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation = {
    import SessionKeyDerivation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation
      .builder()
      .optionallyWith(amex.map(value => value.buildAwsValue()))(_.amex)
      .optionallyWith(emv2000.map(value => value.buildAwsValue()))(_.emv2000)
      .optionallyWith(emvCommon.map(value => value.buildAwsValue()))(
        _.emvCommon
      )
      .optionallyWith(mastercard.map(value => value.buildAwsValue()))(
        _.mastercard
      )
      .optionallyWith(visa.map(value => value.buildAwsValue()))(_.visa)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly =
    zio.aws.paymentcryptographydata.model.SessionKeyDerivation
      .wrap(buildAwsValue())
}
object SessionKeyDerivation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.SessionKeyDerivation =
      zio.aws.paymentcryptographydata.model.SessionKeyDerivation(
        amex.map(value => value.asEditable),
        emv2000.map(value => value.asEditable),
        emvCommon.map(value => value.asEditable),
        mastercard.map(value => value.asEditable),
        visa.map(value => value.asEditable)
      )
    def amex: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly
    ]
    def emv2000: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly
    ]
    def emvCommon: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly
    ]
    def mastercard: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly
    ]
    def visa: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyVisa.ReadOnly
    ]
    def getAmex: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly
    ] = AwsError.unwrapOptionField("amex", amex)
    def getEmv2000: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly
    ] = AwsError.unwrapOptionField("emv2000", emv2000)
    def getEmvCommon: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly
    ] = AwsError.unwrapOptionField("emvCommon", emvCommon)
    def getMastercard: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly
    ] = AwsError.unwrapOptionField("mastercard", mastercard)
    def getVisa: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.SessionKeyVisa.ReadOnly
    ] = AwsError.unwrapOptionField("visa", visa)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation
  ) extends zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly {
    override val amex: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyAmex.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amex())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SessionKeyAmex.wrap(value)
      )
    override val emv2000: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emv2000())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SessionKeyEmv2000.wrap(value)
      )
    override val emvCommon: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.emvCommon())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SessionKeyEmvCommon.wrap(value)
      )
    override val mastercard: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyMastercard.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mastercard())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SessionKeyMastercard.wrap(value)
      )
    override val visa: Optional[
      zio.aws.paymentcryptographydata.model.SessionKeyVisa.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visa())
      .map(value =>
        zio.aws.paymentcryptographydata.model.SessionKeyVisa.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyDerivation
  ): zio.aws.paymentcryptographydata.model.SessionKeyDerivation.ReadOnly =
    new Wrapper(impl)
}
