package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  KeyArnOrKeyAliasType,
  HexEvenLengthBetween16And4096
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReEncryptDataRequest(
    cipherText: HexEvenLengthBetween16And4096,
    incomingEncryptionAttributes: zio.aws.paymentcryptographydata.model.ReEncryptionAttributes,
    incomingKeyIdentifier: KeyArnOrKeyAliasType,
    outgoingEncryptionAttributes: zio.aws.paymentcryptographydata.model.ReEncryptionAttributes,
    outgoingKeyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest = {
    import ReEncryptDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest
      .builder()
      .cipherText(
        HexEvenLengthBetween16And4096.unwrap(cipherText): java.lang.String
      )
      .incomingEncryptionAttributes(
        incomingEncryptionAttributes.buildAwsValue()
      )
      .incomingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(incomingKeyIdentifier): java.lang.String
      )
      .outgoingEncryptionAttributes(
        outgoingEncryptionAttributes.buildAwsValue()
      )
      .outgoingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(outgoingKeyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.ReEncryptDataRequest.ReadOnly =
    zio.aws.paymentcryptographydata.model.ReEncryptDataRequest
      .wrap(buildAwsValue())
}
object ReEncryptDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.ReEncryptDataRequest =
      zio.aws.paymentcryptographydata.model.ReEncryptDataRequest(
        cipherText,
        incomingEncryptionAttributes.asEditable,
        incomingKeyIdentifier,
        outgoingEncryptionAttributes.asEditable,
        outgoingKeyIdentifier
      )
    def cipherText: HexEvenLengthBetween16And4096
    def incomingEncryptionAttributes
        : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly
    def incomingKeyIdentifier: KeyArnOrKeyAliasType
    def outgoingEncryptionAttributes
        : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly
    def outgoingKeyIdentifier: KeyArnOrKeyAliasType
    def getCipherText: ZIO[Any, Nothing, HexEvenLengthBetween16And4096] =
      ZIO.succeed(cipherText)
    def getIncomingEncryptionAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly
    ] = ZIO.succeed(incomingEncryptionAttributes)
    def getIncomingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(incomingKeyIdentifier)
    def getOutgoingEncryptionAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly
    ] = ZIO.succeed(outgoingEncryptionAttributes)
    def getOutgoingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(outgoingKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest
  ) extends zio.aws.paymentcryptographydata.model.ReEncryptDataRequest.ReadOnly {
    override val cipherText: HexEvenLengthBetween16And4096 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexEvenLengthBetween16And4096(impl.cipherText())
    override val incomingEncryptionAttributes
        : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.ReEncryptionAttributes
        .wrap(impl.incomingEncryptionAttributes())
    override val incomingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.incomingKeyIdentifier())
    override val outgoingEncryptionAttributes
        : zio.aws.paymentcryptographydata.model.ReEncryptionAttributes.ReadOnly =
      zio.aws.paymentcryptographydata.model.ReEncryptionAttributes
        .wrap(impl.outgoingEncryptionAttributes())
    override val outgoingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptographydata.model.primitives
        .KeyArnOrKeyAliasType(impl.outgoingKeyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.ReEncryptDataRequest
  ): zio.aws.paymentcryptographydata.model.ReEncryptDataRequest.ReadOnly =
    new Wrapper(impl)
}
