package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PinVerificationAttributes(
    ibm3624Pin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinVerification
    ] = Optional.Absent,
    visaPin: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes = {
    import PinVerificationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes
      .builder()
      .optionallyWith(ibm3624Pin.map(value => value.buildAwsValue()))(
        _.ibm3624Pin
      )
      .optionallyWith(visaPin.map(value => value.buildAwsValue()))(_.visaPin)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.PinVerificationAttributes
      .wrap(buildAwsValue())
}
object PinVerificationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.PinVerificationAttributes =
      zio.aws.paymentcryptographydata.model.PinVerificationAttributes(
        ibm3624Pin.map(value => value.asEditable),
        visaPin.map(value => value.asEditable)
      )
    def ibm3624Pin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly
    ]
    def visaPin: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly
    ]
    def getIbm3624Pin: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly
    ] = AwsError.unwrapOptionField("ibm3624Pin", ibm3624Pin)
    def getVisaPin: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly
    ] = AwsError.unwrapOptionField("visaPin", visaPin)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes
  ) extends zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly {
    override val ibm3624Pin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ibm3624Pin())
      .map(value =>
        zio.aws.paymentcryptographydata.model.Ibm3624PinVerification.wrap(value)
      )
    override val visaPin: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visaPin())
      .map(value =>
        zio.aws.paymentcryptographydata.model.VisaPinVerification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinVerificationAttributes
  ): zio.aws.paymentcryptographydata.model.PinVerificationAttributes.ReadOnly =
    new Wrapper(impl)
}
