package zio.aws.paymentcryptographydata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PinGenerationAttributes(
    ibm3624NaturalPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin
    ] = Optional.Absent,
    ibm3624PinFromOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinFromOffset
    ] = Optional.Absent,
    ibm3624PinOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinOffset
    ] = Optional.Absent,
    ibm3624RandomPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624RandomPin
    ] = Optional.Absent,
    visaPin: Optional[zio.aws.paymentcryptographydata.model.VisaPin] =
      Optional.Absent,
    visaPinVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerificationValue
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes = {
    import PinGenerationAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes
      .builder()
      .optionallyWith(ibm3624NaturalPin.map(value => value.buildAwsValue()))(
        _.ibm3624NaturalPin
      )
      .optionallyWith(ibm3624PinFromOffset.map(value => value.buildAwsValue()))(
        _.ibm3624PinFromOffset
      )
      .optionallyWith(ibm3624PinOffset.map(value => value.buildAwsValue()))(
        _.ibm3624PinOffset
      )
      .optionallyWith(ibm3624RandomPin.map(value => value.buildAwsValue()))(
        _.ibm3624RandomPin
      )
      .optionallyWith(visaPin.map(value => value.buildAwsValue()))(_.visaPin)
      .optionallyWith(
        visaPinVerificationValue.map(value => value.buildAwsValue())
      )(_.visaPinVerificationValue)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly =
    zio.aws.paymentcryptographydata.model.PinGenerationAttributes
      .wrap(buildAwsValue())
}
object PinGenerationAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptographydata.model.PinGenerationAttributes =
      zio.aws.paymentcryptographydata.model.PinGenerationAttributes(
        ibm3624NaturalPin.map(value => value.asEditable),
        ibm3624PinFromOffset.map(value => value.asEditable),
        ibm3624PinOffset.map(value => value.asEditable),
        ibm3624RandomPin.map(value => value.asEditable),
        visaPin.map(value => value.asEditable),
        visaPinVerificationValue.map(value => value.asEditable)
      )
    def ibm3624NaturalPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly
    ]
    def ibm3624PinFromOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinFromOffset.ReadOnly
    ]
    def ibm3624PinOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly
    ]
    def ibm3624RandomPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624RandomPin.ReadOnly
    ]
    def visaPin
        : Optional[zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly]
    def visaPinVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly
    ]
    def getIbm3624NaturalPin: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly
    ] = AwsError.unwrapOptionField("ibm3624NaturalPin", ibm3624NaturalPin)
    def getIbm3624PinFromOffset: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.Ibm3624PinFromOffset.ReadOnly
    ] = AwsError.unwrapOptionField("ibm3624PinFromOffset", ibm3624PinFromOffset)
    def getIbm3624PinOffset: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly
    ] = AwsError.unwrapOptionField("ibm3624PinOffset", ibm3624PinOffset)
    def getIbm3624RandomPin: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.Ibm3624RandomPin.ReadOnly
    ] = AwsError.unwrapOptionField("ibm3624RandomPin", ibm3624RandomPin)
    def getVisaPin: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly
    ] = AwsError.unwrapOptionField("visaPin", visaPin)
    def getVisaPinVerificationValue: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "visaPinVerificationValue",
      visaPinVerificationValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes
  ) extends zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly {
    override val ibm3624NaturalPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ibm3624NaturalPin())
      .map(value =>
        zio.aws.paymentcryptographydata.model.Ibm3624NaturalPin.wrap(value)
      )
    override val ibm3624PinFromOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinFromOffset.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ibm3624PinFromOffset())
      .map(value =>
        zio.aws.paymentcryptographydata.model.Ibm3624PinFromOffset.wrap(value)
      )
    override val ibm3624PinOffset: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ibm3624PinOffset())
      .map(value =>
        zio.aws.paymentcryptographydata.model.Ibm3624PinOffset.wrap(value)
      )
    override val ibm3624RandomPin: Optional[
      zio.aws.paymentcryptographydata.model.Ibm3624RandomPin.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ibm3624RandomPin())
      .map(value =>
        zio.aws.paymentcryptographydata.model.Ibm3624RandomPin.wrap(value)
      )
    override val visaPin
        : Optional[zio.aws.paymentcryptographydata.model.VisaPin.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visaPin())
        .map(value => zio.aws.paymentcryptographydata.model.VisaPin.wrap(value))
    override val visaPinVerificationValue: Optional[
      zio.aws.paymentcryptographydata.model.VisaPinVerificationValue.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.visaPinVerificationValue())
      .map(value =>
        zio.aws.paymentcryptographydata.model.VisaPinVerificationValue
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes
  ): zio.aws.paymentcryptographydata.model.PinGenerationAttributes.ReadOnly =
    new Wrapper(impl)
}
