package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait PinBlockFormatForPinData {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData
}
object PinBlockFormatForPinData {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData
  ): zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData =
    value match {
      case software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.ISO_FORMAT_0 =>
        val r = ISO_FORMAT_0
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.ISO_FORMAT_3 =>
        val r = ISO_FORMAT_3
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData =
      software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.UNKNOWN_TO_SDK_VERSION
  }
  case object ISO_FORMAT_0
      extends zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData =
      software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.ISO_FORMAT_0
  }
  case object ISO_FORMAT_3
      extends zio.aws.paymentcryptographydata.model.PinBlockFormatForPinData {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData =
      software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData.ISO_FORMAT_3
  }
}
