package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait PaddingType {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType
}
object PaddingType {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType
  ): zio.aws.paymentcryptographydata.model.PaddingType = value match {
    case software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.PKCS1 =>
      val r = PKCS1
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA1 =>
      val r = OAEP_SHA1
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA256 =>
      val r = OAEP_SHA256
      r
    case software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA512 =>
      val r = OAEP_SHA512
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.PaddingType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType =
      software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.UNKNOWN_TO_SDK_VERSION
  }
  case object PKCS1 extends zio.aws.paymentcryptographydata.model.PaddingType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType =
      software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.PKCS1
  }
  case object OAEP_SHA1
      extends zio.aws.paymentcryptographydata.model.PaddingType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType =
      software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA1
  }
  case object OAEP_SHA256
      extends zio.aws.paymentcryptographydata.model.PaddingType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType =
      software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA256
  }
  case object OAEP_SHA512
      extends zio.aws.paymentcryptographydata.model.PaddingType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType =
      software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType.OAEP_SHA512
  }
}
