package zio.aws.paymentcryptographydata.model
import scala.jdk.CollectionConverters.*
sealed trait MajorKeyDerivationMode {
  def unwrap: software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode
}
object MajorKeyDerivationMode {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode
  ): zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode =
    value match {
      case software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.EMV_OPTION_A =>
        val r = EMV_OPTION_A
        r
      case software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.EMV_OPTION_B =>
        val r = EMV_OPTION_B
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object EMV_OPTION_A
      extends zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.EMV_OPTION_A
  }
  case object EMV_OPTION_B
      extends zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode =
      software.amazon.awssdk.services.paymentcryptographydata.model.MajorKeyDerivationMode.EMV_OPTION_B
  }
}
