package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.{
  NumberLengthBetween12And19,
  HexLengthEquals2
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MacAlgorithmEmv(
    majorKeyDerivationMode: zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode,
    panSequenceNumber: HexLengthEquals2,
    primaryAccountNumber: NumberLengthBetween12And19,
    sessionKeyDerivationMode: zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode,
    sessionKeyDerivationValue: zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv = {
    import MacAlgorithmEmv.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv
      .builder()
      .majorKeyDerivationMode(majorKeyDerivationMode.unwrap)
      .panSequenceNumber(
        HexLengthEquals2.unwrap(panSequenceNumber): java.lang.String
      )
      .primaryAccountNumber(
        NumberLengthBetween12And19.unwrap(
          primaryAccountNumber
        ): java.lang.String
      )
      .sessionKeyDerivationMode(sessionKeyDerivationMode.unwrap)
      .sessionKeyDerivationValue(sessionKeyDerivationValue.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly =
    zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.wrap(buildAwsValue())
}
object MacAlgorithmEmv {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.MacAlgorithmEmv =
      zio.aws.paymentcryptographydata.model.MacAlgorithmEmv(
        majorKeyDerivationMode,
        panSequenceNumber,
        primaryAccountNumber,
        sessionKeyDerivationMode,
        sessionKeyDerivationValue.asEditable
      )
    def majorKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
    def panSequenceNumber: HexLengthEquals2
    def primaryAccountNumber: NumberLengthBetween12And19
    def sessionKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode
    def sessionKeyDerivationValue
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly
    def getMajorKeyDerivationMode: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
    ] = ZIO.succeed(majorKeyDerivationMode)
    def getPanSequenceNumber: ZIO[Any, Nothing, HexLengthEquals2] =
      ZIO.succeed(panSequenceNumber)
    def getPrimaryAccountNumber: ZIO[Any, Nothing, NumberLengthBetween12And19] =
      ZIO.succeed(primaryAccountNumber)
    def getSessionKeyDerivationMode: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode
    ] = ZIO.succeed(sessionKeyDerivationMode)
    def getSessionKeyDerivationValue: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly
    ] = ZIO.succeed(sessionKeyDerivationValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv
  ) extends zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly {
    override val majorKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode =
      zio.aws.paymentcryptographydata.model.MajorKeyDerivationMode
        .wrap(impl.majorKeyDerivationMode())
    override val panSequenceNumber: HexLengthEquals2 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthEquals2(impl.panSequenceNumber())
    override val primaryAccountNumber: NumberLengthBetween12And19 =
      zio.aws.paymentcryptographydata.model.primitives
        .NumberLengthBetween12And19(impl.primaryAccountNumber())
    override val sessionKeyDerivationMode
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode =
      zio.aws.paymentcryptographydata.model.SessionKeyDerivationMode
        .wrap(impl.sessionKeyDerivationMode())
    override val sessionKeyDerivationValue
        : zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue.ReadOnly =
      zio.aws.paymentcryptographydata.model.SessionKeyDerivationValue
        .wrap(impl.sessionKeyDerivationValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmEmv
  ): zio.aws.paymentcryptographydata.model.MacAlgorithmEmv.ReadOnly =
    new Wrapper(impl)
}
