package zio.aws.paymentcryptographydata.model
import zio.aws.paymentcryptographydata.model.primitives.HexLengthBetween10And24
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MacAlgorithmDukpt(
    dukptDerivationType: Optional[
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = Optional.Absent,
    dukptKeyVariant: zio.aws.paymentcryptographydata.model.DukptKeyVariant,
    keySerialNumber: HexLengthBetween10And24
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt = {
    import MacAlgorithmDukpt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt
      .builder()
      .optionallyWith(dukptDerivationType.map(value => value.unwrap))(
        _.dukptDerivationType
      )
      .dukptKeyVariant(dukptKeyVariant.unwrap)
      .keySerialNumber(
        HexLengthBetween10And24.unwrap(keySerialNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly =
    zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt
      .wrap(buildAwsValue())
}
object MacAlgorithmDukpt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt =
      zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt(
        dukptDerivationType.map(value => value),
        dukptKeyVariant,
        keySerialNumber
      )
    def dukptDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType]
    def dukptKeyVariant: zio.aws.paymentcryptographydata.model.DukptKeyVariant
    def keySerialNumber: HexLengthBetween10And24
    def getDukptDerivationType: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptographydata.model.DukptDerivationType
    ] = AwsError.unwrapOptionField("dukptDerivationType", dukptDerivationType)
    def getDukptKeyVariant: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
    ] = ZIO.succeed(dukptKeyVariant)
    def getKeySerialNumber: ZIO[Any, Nothing, HexLengthBetween10And24] =
      ZIO.succeed(keySerialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt
  ) extends zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly {
    override val dukptDerivationType
        : Optional[zio.aws.paymentcryptographydata.model.DukptDerivationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dukptDerivationType())
        .map(value =>
          zio.aws.paymentcryptographydata.model.DukptDerivationType.wrap(value)
        )
    override val dukptKeyVariant
        : zio.aws.paymentcryptographydata.model.DukptKeyVariant =
      zio.aws.paymentcryptographydata.model.DukptKeyVariant
        .wrap(impl.dukptKeyVariant())
    override val keySerialNumber: HexLengthBetween10And24 =
      zio.aws.paymentcryptographydata.model.primitives
        .HexLengthBetween10And24(impl.keySerialNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptographydata.model.MacAlgorithmDukpt
  ): zio.aws.paymentcryptographydata.model.MacAlgorithmDukpt.ReadOnly =
    new Wrapper(impl)
}
